% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.fast.Bayes.fit}
\alias{GP.fast.Bayes.fit}
\title{Fast Bayesian fitting of Gaussian process}
\usage{
GP.fast.Bayes.fit(
  y,
  x,
  poly_degree = 10L,
  a = 0.01,
  b = 1,
  center = NULL,
  scale = NULL,
  max_range = NULL,
  num_results = 500L,
  iters_between_results = 2L,
  burn_in = 500L,
  a_sigma = 0.01,
  b_sigma = 0.01,
  a_tau = 0.01,
  b_tau = 0.01,
  progress_bar = FALSE
)
}
\arguments{
\item{y}{A vector of real numbers as the observations for the reponse variable.}

\item{x}{A matrix of real numbers as grid points where rows are observations and columns are coordinates.}

\item{poly_degree}{A integer number to specify the highest degree of Hermite polynomials. The default value is 10L.}

\item{a}{A positive real number to specify the concentration parameter in the standard modified exponential squared kernel. The larger value the more the GP concentrates around the center. The default value is 0.01.}

\item{b}{A positive real number to specify the smoothness parameter in the standard modified exponential squared kernel. The smaller value the smoother the GP is. The default value is 1.0.}

\item{center}{A vector of real numbers specifying the centroid parameters in the modified exponential squared kernel. The default value is NULL and set to the center of the grid points: apply(x,2,mean).}

\item{scale}{A vector of positive numbers specifying the scale parameters in the modified exponential squared kernel. The default value is NULL and set to values such that grid points in a range of (-max_range,max_range) in each dimension.}

\item{max_range}{A positive real number indicating the maximum range of the grid points to specify the scale parameter. The default value is NULL and set to 6.}

\item{num_results}{An integer number to specify the number of posterior samples to save over MCMC iterations.}

\item{iters_between_results}{An integer number to specify the number of iterations to skip between two saved iterations.}

\item{burn_in}{An integer number to specify the burn-in number. The default value is 500L.}

\item{a_sigma}{A real number for the shape parameter in the Gamma prior of sigma2. The default value is 0.01.}

\item{b_sigma}{A real number for the rate parameter in the Gamma prior of sigma2. The default value is 0.01.}

\item{a_tau}{A real number for the shape parameter in the Gamma prior of tau2. The default value is 0.01.}

\item{b_tau}{A real number for the rate parameter in the Gamma prior of tau2. The default value is 0.01.}

\item{progress_bar}{A logical value to indicate whether a progress bar will be shown.}
}
\value{
A list of variables including the model fitting results
\describe{
 \item{f}{A vector of real numbers for the posterior mean of the fitted curve.}
 \item{x}{A matrix of real numbers for the grid points where rows are observations and columns are coordinates.}
 \item{work_x}{A matrix of real numbers for the standardized grid points for the model fitting. It has the same dimension as "x".}
 \item{sigma2}{A real number for the posterior mean of the variance parameter of random errors.}
 \item{tau2}{A real number for the posterior mean of the variance parameter for the Gaussian process prior.}
 \item{theta}{A vector of real numbers for the posterior mean of the basis coefficients for the Gaussian process.}
 \item{Xmat}{A matrix real numbers for the basis functions evaluated at the standardized grid points (work_x), where rows are observations and columns are the basis functions}
 \item{grid_size}{A real scalar for the grid size}
 \item{center}{A vector of real numbers for the centroid parameters in the modified exponential squared kernel.}
 \item{scale}{A vector of positive numbers for the scale parameters in the modified exponential squared kernel.}
 \item{max_range}{A positive real number indicating the maximum range of the grid points to specify the scale parameter.}
 \item{poly_degree}{An integer number to specify the highest degree of Hermite polynomials.}
 \item{a}{A positive real number to specify the concentration parameter in the standard modified exponential squared kernel.}
 \item{b}{A positive real number to specify the smoothness parameter in the standard modified exponential squared kernel.}
 \item{mcmc_sample}{A matrix of real numbers for saved MCMC samples.}
 \item{elapsed}{A real number indicating the computing time in second}
}
}
\description{
Fast Bayesian fitting of Gaussian process regression on regular grid points with the modified exponential sqaured kernel.
}
\examples{
library(BayesGPfit)
library(lattice)
set.seed(1224)
dat = list()
dat$x = GP.generate.grids(d=2,num_grids = 100)
curve = GP.simulate.curve.fast(dat$x,a=0.01,b=0.5,poly_degree=20L)
dat$f = curve$f + rnorm(length(curve$f),sd=1)
fit = GP.fast.Bayes.fit(dat$f,dat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
plot(GP.plot.curve(dat,main="Data"),split=c(1,1,2,2),more=TRUE)
plot(GP.plot.curve(curve,main="True curve"),split=c(1,2,2,2),more=TRUE)
plot(GP.plot.curve(fit,main="Posterior mean estimates"),split=c(2,2,2,2),more=TRUE)


}
\author{
Jian Kang <jiankang@umich.edu>
}
