% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.X.R
\name{make.X}
\alias{make.X}
\title{Forms matrix of components}
\usage{
make.X(df, num.groups, groups)
}
\arguments{
\item{df}{A dataframe containing named component variables}

\item{num.groups}{An integer representing the number of component groups desired}

\item{groups}{A list, each item in the list being a string vector of variable names for one component group}
}
\value{
A matrix of component variables
}
\description{
This function returns a matrix of component variables, X. The user can specify
the desired chemicals and order by creating a list of string vectors, each vector containing the variable names of all
desired elements of that group.
}
\examples{
data("simdata")
group_list <- list(c("pcb_118", "pcb_138", "pcb_153", "pcb_180", "pcb_192"),
                   c("as", "cu", "pb", "sn"),
                   c("carbaryl", "propoxur", "methoxychlor", "diazinon", "chlorpyrifos"))
X <- make.X(simdata, 3, group_list)
X
}
