% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgwqs.fit.R
\name{bgwqs.fit}
\alias{bgwqs.fit}
\title{Bayesian Grouped WQS Regression}
\usage{
bgwqs.fit(
  y,
  x,
  x.s,
  n.quantiles = 4,
  working.dir,
  mcmc = "jags",
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  n.adapt = 500,
  debug = FALSE
)
}
\arguments{
\item{y}{A vector containing outcomes.}

\item{x}{A matrix of component data.}

\item{x.s}{A vector of the number of components in each index.}

\item{n.quantiles}{The number of quantiles to apply to the component data.}

\item{working.dir}{A file path to the directory.}

\item{mcmc}{The MCMC program to be used for analysis. Currently "jags" and "openbugs" are supported arguments.}

\item{n.iter}{The number of total iterations per chain, including burn in.}

\item{n.burnin}{The number of iterations to discard at the beginning.}

\item{n.thin}{The thinning rate, which must be a positive integer.}

\item{n.adapt}{The number of adaption iterations, only required for JAGS analyses.}

\item{debug}{Only for OpenBUGS analyses. False by default, when true OpenBUGS remains open for further investigation.}
}
\value{
A list which includes BUGS output, sample chains post-burnin, and convergence test results.
}
\description{
This function fits a Bayesian grouped weighted quantile sum (BGWQS) regression model.
}
\examples{
\donttest{
data("simdata")
group_list <- list(c("pcb_118", "pcb_138", "pcb_153", "pcb_180", "pcb_192"),
                   c("as", "cu", "pb", "sn"),
                   c("carbaryl", "propoxur", "methoxychlor", "diazinon", "chlorpyrifos"))
x.s <- make.x.s(simdata, 3, group_list)
X <- make.X(simdata, 3, group_list)
Y <- simdata$Y
work_dir <- tempdir()
results <- bgwqs.fit(y = Y, x = X, x.s = x.s, n.quantiles=4, working.dir = work_dir, mcmc = "jags",
                    n.iter = 10000, n.burnin = 5000, n.thin = 1, n.adapt = 500)
}

}
