% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hier_model.R
\name{LN_hier_existence}
\alias{LN_hier_existence}
\title{Numerical evaluation of the log-normal conditioned means posterior moments}
\usage{
LN_hier_existence(X, Z, Xtilde, order_moment = 2, s = 1, m = NULL)
}
\arguments{
\item{X}{Design matrix for fixed effects.}

\item{Z}{Design matrix for random effects.}

\item{Xtilde}{Covariate patterns used for the leverage computation.}

\item{order_moment}{Order of the posterior moments required to be finite.}

\item{s}{Number of variances of the random effects.}

\item{m}{Vector of size \code{s} (if s>1) that indicates the dimensions of the random effect vectors.}
}
\value{
Both the values of the factors determining the existence condition and the values of the gamma parameters for the different
variance components are provided.
}
\description{
Function that evaluates the existence conditions for moments of useful quantities in the original data scale
when a log-normal linear mixed model is estimated.
}
\details{
This function computes the existence conditions for the moments up to order fixed by \code{order_moment} of the log-normal
linear mixed model specified by the design matrices \code{X} and \code{Z}. It considers the prediction based on multiple
covariate patterns stored in the rows of the \code{Xtilde} matrix.
}
