% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-Q-alpha_tau2.R
\name{make_Q_alpha_tau2}
\alias{make_Q_alpha_tau2}
\title{Title}
\usage{
make_Q_alpha_tau2(Q_alpha, tau2, use_spam = TRUE)
}
\arguments{
\item{Q_alpha}{a list of length M composed of matrices that are the correlation structure of the CAR prior on beta.}

\item{tau2}{a vector of length M that contains the CAR prior precision matrices.}

\item{use_spam}{a boolean that determines if the output matrix is of class "spam" (\code{use_spam = TRUE}) or of class "dgCMatrix" (\code{use_spam = FALSE}; see Matrix package for details).}
}
\value{
A sparse block diagonal matrix representing the precision matrices for all of the resolutions of the random effects.
}
\description{
Title
}
\examples{
n_dims <- c(4, 8)
phi <- c(0.8, 0.9)
tau2 <- c(3, 4)
Q_alpha <- make_Q_alpha_2d(n_dims, phi)
Q_alpha_tau2 <- make_Q_alpha_tau2(Q_alpha, tau2)
## plot the full precision matrix structure
spam::display(Q_alpha_tau2)

}
