context("Testing that the random numbers are equal between platforms")

bmm <- compute_mallows_mixtures(n_clusters = c(1, 4),
                                rankings = sushi_rankings, nmc = 50,
                                save_clus = FALSE, include_wcd = FALSE, seed = 432)


expect_equal(bmm[[2]]$cluster_probs$value[1:50],
          c(0.25, 0.25, 0.25, 0.25, 0.250115858981958, 0.245833894814954,
            0.24776442243802, 0.256285823765068, 0.257600323634538, 0.252693727395573,
            0.244502697360398, 0.245203251609491, 0.253418557368672, 0.260601888760137,
            0.246683252521446, 0.239296301349745, 0.279278590913116, 0.254126772102222,
            0.244300313652007, 0.222294323332656, 0.312451512895017, 0.239789526115628,
            0.234959718617507, 0.212799242371848, 0.332967281175225, 0.245956335337992,
            0.213119016640605, 0.207957366846178, 0.391772556134217, 0.227552368738536,
            0.185597149080881, 0.195077926046366, 0.430729393795561, 0.213973524712854,
            0.170141598665673, 0.185155482825912, 0.484662185861676, 0.19093991420075,
            0.166442786097268, 0.157955113840305, 0.527620034374942, 0.187590260718884,
            0.140481678129351, 0.144308026776823, 0.549119521970855, 0.182710449432327,
            0.142012556950746, 0.126157471646072, 0.561275681723442, 0.181888150698294
          ))


m <- compute_mallows(sushi_rankings, n_clusters = 5, seed = 123, nmc = 20)

expect_equal(m$cluster_probs$value,
          c(0.2, 0.2, 0.2, 0.2, 0.2, 0.211429132832491, 0.187035286787252,
            0.199569648079635, 0.196576755493794, 0.205389176806829, 0.21580404196551,
            0.178357519344898, 0.211977904759912, 0.202815160891299, 0.191045373038381,
            0.211507707495563, 0.192072417033454, 0.197524243184311, 0.195236685516787,
            0.203658946769885, 0.21417127587524, 0.201744469120015, 0.167735080609759,
            0.214991383737803, 0.201357790657182, 0.202128692778427, 0.227613665515914,
            0.126213469457355, 0.231001225036429, 0.213042947211875, 0.180979683299446,
            0.275990581812069, 0.106442808164998, 0.231518180488985, 0.205068746234501,
            0.164849496525133, 0.348389806406647, 0.0995318144803266, 0.203542239863869,
            0.183686642724025, 0.143582995391147, 0.400486111887601, 0.103194135073862,
            0.188744777668161, 0.163991979979228, 0.124654371700526, 0.454614436132987,
            0.102831445691448, 0.182949067316672, 0.134950679158367, 0.113333766836492,
            0.498007276217168, 0.0912050878486828, 0.177096622675254, 0.120357246422403,
            0.0975591890340341, 0.534822947980525, 0.0746937458573969, 0.175895393634861,
            0.117028723493182, 0.0817821397898058, 0.572509728576925, 0.0691571423969067,
            0.167744668058275, 0.108806321178087, 0.0694324086721602, 0.612420262072963,
            0.068542749192071, 0.160759661098381, 0.0888449189644251, 0.0718288578600643,
            0.62118291544352, 0.0596722423003294, 0.153434702799394, 0.0938812815966927,
            0.0705295862806602, 0.655697328806464, 0.0530701418870458, 0.142411298996897,
            0.0782916440289323, 0.0686240341126687, 0.658292900816629, 0.0510502931972015,
            0.14241941271786, 0.0796133591556417, 0.0629652172953892, 0.674475823687687,
            0.0513777255689705, 0.134760042343451, 0.0764211911045023, 0.0593942788932232,
            0.693510717141139, 0.0557190369455303, 0.122999076800109, 0.0683768902199986,
            0.0498145983522444, 0.69571258585339, 0.0515453814250031, 0.132154102430601,
            0.0707733319387615))
