% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_dataset}
\alias{sample_dataset}
\title{A synthetic 3D matrix generated using the sample_mallows function}
\format{
An object of class \code{array} of dimension 10 x 6 x 31.
}
\usage{
sample_dataset
}
\description{
A synthetic 3D matrix (\code{n_users}, \code{n_items}, \code{Time}) generated
using the sample_mallows function. These are test datasets used to run
the SMC-Mallows framework for the cases where we know all of the users
in our system and their original ranking information are partial rankings.
However at some point in time, we observe extra information about
an existing user in the form of a rank for an item that was previously
not known (\code{NA}). These datasets are very contrived as the first
time step (\code{sample_dataset[, , 1]}) we observed the top \code{m / 2}
items from each user, where \code{m} is the number of items in a ranking.
Then, as we increase the time, we observe the next top ranked item from
one user at a time, then the next top ranked item, and so on until we have
a complete dataset at \code{sample_dataset[, , Time]}.
}
\references{
https://github.com/anjastein/SMC-Mallows/tree/main/data
}
\seealso{
Other datasets: 
\code{\link{beach_preferences}},
\code{\link{potato_true_ranking}},
\code{\link{potato_visual}},
\code{\link{potato_weighing}},
\code{\link{sushi_rankings}}
}
\concept{datasets}
\keyword{datasets}
