% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMarginals.R
\name{PlotMarginals}
\alias{PlotMarginals}
\title{Plot the marginal distributions}
\usage{
PlotMarginals(marginals, groups = NULL)
}
\arguments{
\item{marginals}{the marginal distributions returned by \code{Marginals} for plotting}

\item{groups}{names of the marginals to be shown on plots}
}
\description{
Plot the marginal distributions.
}
\details{
Plot the marginal distributions. Marginals of discrete variables are plotted as 
bar plots, while those of continuous variables as density plots.
}
\examples{
data(toytree)
marg <- Marginals(toytree, c("A", "B", "H", "J"))
PlotMarginals(marginals=marg, groups=NULL)

}
\author{
Han Yu
}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks. 
Journal of Machine Learning Research, 6(Sep), 1517-1550.
}
\seealso{
\code{\link{Marginals}}
}

