% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_2_ClusterTree.R
\docType{class}
\name{ClusterTree-class}
\alias{ClusterTree-class}
\title{An S4 class of the cluster tree.}
\description{
The \code{ClusterTree} object is the computational object for belief propagation.
}
\section{Slots}{

\describe{
\item{\code{cluster}}{A \code{vector} storing the name of clusters in the cluster tree.}

\item{\code{node}}{A \code{vector} storing the name of nodes in the Bayesian network.}

\item{\code{graph}}{A \code{list} of two graphNEL objects: \code{$dag} stores the graph of Bayesian network,
\code{$tree} stores the graph of the cluster tree.}

\item{\code{member}}{A named \code{list} of the node cluster membership.}

\item{\code{parent}}{A named \code{vector} indicating the parent node of a given cluster in the cluster tree.}

\item{\code{cluster.class}}{A named \code{vector} of logical values indicating whether a cluster is continuous or discrete.}

\item{\code{node.class}}{A named \code{vector} of logical values indicating whether a node is continuous or discrete.}

\item{\code{assignment}}{A named \code{list} indicating the assignment of discrete nodes discrete clusters.}

\item{\code{propagated}}{A \code{logical} value indicating whether the discrete compartment has been propagated.}

\item{\code{cpt}}{A named \code{list} of the conditional probability tables.}

\item{\code{jpt}}{A named \code{list} of the joint distribution tables.}

\item{\code{lppotential}}{A named \code{list} of the linear predictor potentials assigned to each cluster in the lppotential slots.}

\item{\code{postbag}}{A named \code{list} of the linear predictor potentials assigned to each cluster in the postbag slots.}

\item{\code{activefalg}}{A named \code{vector} of logical values indicating whether a continuous cluster is active.}

\item{\code{absorbed.variables}}{A \code{vector} of characters indicating variables observed with hard evidence.}

\item{\code{absorbed.values}}{A \code{list} indicating the values of the variables observed with hard evidence.}

\item{\code{absorbed.soft.variables}}{A \code{vector} of characters indicating variables observed with soft or likelihood evidence.}

\item{\code{absorbed.soft.values}}{A \code{list} of the likelihoods of the soft or likelihood evidence.}
}}

