% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phm_random_a0.R
\name{power.phm.random.a0}
\alias{power.phm.random.a0}
\title{Power/type I error calculation for the proportional hazards model with piecewise constant hazard and random a0}
\usage{
power.phm.random.a0(
  historical,
  n.subjects,
  n.events,
  n.intervals,
  change.points = NULL,
  samp.prior.beta,
  samp.prior.lambda,
  dist.enroll,
  param.enroll,
  rand.prob = 0.5,
  prob.drop = 0,
  param.drop = 0,
  dist.csr = "Constant",
  param.csr = 10000,
  min.follow.up = 0,
  max.follow.up = 10000,
  prior.beta.mvn = NULL,
  prior.a0.shape1 = rep(1, 10),
  prior.a0.shape2 = rep(1, 10),
  prior.lambda.hp1 = rep(10^(-5), 50),
  prior.lambda.hp2 = rep(10^(-5), 50),
  lower.limits = NULL,
  upper.limits = rep(100, 50),
  slice.widths = rep(0.1, 50),
  nMC = 10000,
  nBI = 250,
  delta = 0,
  nullspace.ineq = ">",
  gamma = 0.95,
  N = 10000
)
}
\arguments{
\item{historical}{List of historical dataset(s). East historical dataset is stored in a list which contains four \emph{named} elements: \code{time}, \code{event}, \code{X} and \code{S}.
\itemize{
\item \code{time} is a vector of follow up times.
\item \code{event} is a vector of status indicators. Normally 0=alive and 1=dead.
\item \code{X} is a matrix of covariates. The first column must be the treatment indicator.
\item \code{S} is a vector of integers, where each integer represents the stratum that the subject belongs to. For example, if there are three strata, S can take values 1, 2 or 3.
}}

\item{n.subjects}{Number of subjects enrolled.}

\item{n.events}{Number of events at which the trial will stop.}

\item{n.intervals}{Vector of integers, indicating the number of intervals for the baseline hazards for each stratum. The length of the vector should be equal to the total number of strata.}

\item{change.points}{List of vectors. Each vector in the list contains the change points for the baseline hazards for each stratum. The length of the vector should be equal to the total number of strata.
By default, we assign the change points so that the same number of events are observed in all the intervals in the historical data.}

\item{samp.prior.beta}{Matrix of possible values of \eqn{\beta} to sample (with replacement) from. Each row is a possible \eqn{\beta} vector (a realization from the sampling prior for \eqn{\beta}).}

\item{samp.prior.lambda}{List of matrices, where each matrix represents the sampling prior for the baseline hazards for each stratum. The number of columns of each matrix should be equal to the number of intervals for that stratum.}

\item{dist.enroll}{Distribution for enrollment times. The choices are "Uniform" or "Exponential".}

\item{param.enroll}{Parameter for the distribution of enrollment times. If \code{dist.enroll} is "Uniform", the enrollment times follow Unif(0, \code{param.enroll}). If \code{dist.enroll} is "Exponential",
the enrollment times follow Exponential(rate=\code{param.enroll}).}

\item{rand.prob}{Randomization probability for the treated group. The default value is 0.5.}

\item{prob.drop}{Probability of subjects dropping out of the study (non-administrative censoring). The default value is zero.}

\item{param.drop}{Parameter for dropout time simulations. The dropout times follow Unif(0, \code{param.drop}). The default value is zero.}

\item{dist.csr}{Distribution for (administrative) censorship times. The choices are "Uniform", "Constant" and "Exponential". The default choice is "Constant".}

\item{param.csr}{Parameter for the (administrative) censorship times. If \code{dist.csr} is "Uniform", the censorship times follow Unif(0, \code{param.csr}).
If \code{dist.csr} is "Constant", the censorship times of all subjects are equal to \code{param.csr}.
If \code{dist.csr} is "Exponential", the censorship times follow Exponential(rate=\code{param.csr}).
The default value is 10^4.}

\item{min.follow.up}{Minimum amount of time for which subjects are followed up. The default value is zero.}

\item{max.follow.up}{Maximum amount of time for which subjects are followed up. The default value is 10^4.}

\item{prior.beta.mvn}{List of vectors of multivariate normal approximations of the normalized power prior for \eqn{\beta}. Each vector has three elements,
the mean vector, the covariance matrix and the weight of the multivariate normal distribution. The normalized power prior for \eqn{\beta}
is approximated by the weighted mixture of the multivariate normal distributions provided. By default, a single multivariate normal distribution is assumed.
The user can use the \code{\link{approximate.prior.beta}} function to obtain samples of \eqn{\beta} from the normalized power prior, and use any mixture of multivariate normals to approximate
the normalized power prior for \eqn{\beta}.}

\item{prior.a0.shape1}{Vector of the first shape parameters of the independent beta priors for \eqn{a_0}. The length of the vector should be equal to the number of historical datasets. The default is a vector of one's.}

\item{prior.a0.shape2}{Vector of the second shape parameters of the independent beta priors for \eqn{a_0}. The length of the vector should be equal to the number of historical datasets. The default is a vector of one's.}

\item{prior.lambda.hp1}{Vector of first hyperparameters of the Gamma initial prior on \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda}.}

\item{prior.lambda.hp2}{Vector of second hyperparameters of the Gamma initial prior on \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda}.}

\item{lower.limits}{Vector of lower limits for parameters (\eqn{\beta} and \eqn{\lambda}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is -100 for \eqn{\beta} and 0 for \eqn{\lambda} (may not be appropriate for all situations).}

\item{upper.limits}{Vector of upper limits for parameters (\eqn{\beta} and \eqn{\lambda}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is 100 for all parameters (may not be appropriate for all situations).}

\item{slice.widths}{Vector of initial slice widths for parameters (\eqn{\beta} and \eqn{\lambda}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is 0.1 for all parameters (may not be appropriate for all situations).}

\item{nMC}{Number of iterations (excluding burn-in samples) for the slice sampler. The default is 10,000.}

\item{nBI}{Number of burn-in samples for the slice sampler. The default is 250.}

\item{delta}{Prespecified constant that defines the boundary of the null hypothesis. The default is zero.}

\item{nullspace.ineq}{Character string specifying the inequality of the null hypothesis. The options are ">" and "<". If ">" is specified, the null hypothesis is \eqn{H_0}: \eqn{\beta_1} \eqn{\ge} \eqn{\delta}. If "<" is specified, the null hypothesis is \eqn{H_0}: \eqn{\beta_1} \eqn{\le} \eqn{\delta}. The default choice is ">".}

\item{gamma}{Posterior probability threshold for rejecting the null. The null hypothesis is rejected if posterior probability is greater \code{gamma}. The default is 0.95.}

\item{N}{Number of simulated datasets to generate. The default is 10,000.}
}
\value{
Power or type I error is returned, depending on the sampling prior used.
The posterior probabilities of the alternative hypothesis are returned.
The average posterior means of \eqn{\beta} and \eqn{\lambda} are also returned.
}
\description{
Power/type I error calculation using the normalized power prior for the proportional hazards model with piecewise constant hazard and random \eqn{a_0}
}
\details{
The proportional hazards model with piecewise constant hazard is implemented.
We assume \eqn{\beta} is the regression coefficients. We assume the first column of the covariate matrix is the treatment indicator,
and the corresponding parameter is \eqn{\beta_1}. Here \eqn{a_0} is modeled as random with a normalized power prior.

The normalized power prior for \eqn{\beta} is approximated by a weighted mixture of multivariate normal distributions provided in \code{prior.beta.mvn}.
The user can use the \code{\link{approximate.prior.beta}} function to obtain samples of \eqn{\beta} from the normalized power prior, and use any mixture of multivariate normals to approximate
the normalized power prior for \eqn{\beta}. By default, a single multivariate normal distribution is assumed.

Baseline hazard parameters for the
current and historical data are NOT shared. The baseline hazards of the current data are denoted by \eqn{\lambda}.
The baseline hazards of the historical data are denoted by \eqn{\lambda_0}. We assume Gamma initial priors for
\eqn{\lambda} and \eqn{\lambda_0}.

To perform sample size determination, we test the hypotheses
\deqn{H_0: \beta_1 \ge \delta} and \deqn{H_1: \beta_1 < \delta.}

The sampling prior for the treatment parameter can be generated from a normal distribution (see examples).
For example, suppose one wants to compute the power for the hypotheses \eqn{H_0: \beta_1 \ge 0} and \eqn{H_1: \beta_1 < 0.}
To approximate the sampling prior for \eqn{\beta_1}, one can simply sample from a normal distribution with negative mean,
so that the mass of the prior falls in the alternative space. Conversely, to compute the type I error rate, one can
sample from a normal distribution with positive mean, so that the mass of the prior falls in the null space.

The sampling prior for the other parameters (\eqn{\beta_2}, ..., \eqn{\beta_p} and \eqn{\lambda}) can be generated from the posterior based on the historical data.
This can be achieved by the function \link{phm.fixed.a0}
with \code{current.data} set to \code{FALSE} (see the vignette).

Posterior samples are obtained through slice sampling.
The default lower limits are -100 for \eqn{\beta} and 0 for \eqn{\lambda}. The default upper limits
for the parameters are 100. The default slice widths for the parameters are 0.1.
The defaults may not be appropriate for all situations, and the user can specify the appropriate limits
and slice width for each parameter.

If a sampling prior with support in the null space is used, the value returned is a Bayesian type I error rate.
If a sampling prior with support in the alternative space is used, the value returned is a Bayesian power.
}
\examples{


# Simulate two historical datasets
set.seed(1)
n <- 100
P <- 4
time1 <- round(rexp(n, rate=0.5),1)
event1 <- rep(1,n)
X1 <- matrix(rbinom(n*P,prob=0.5,size=1), ncol=P)
S1 <- c(rep(1,n/2),rep(2,n/2))
time2 <- round(rexp(n, rate=0.7),1)
event2 <- rep(1,n)
X2 <- matrix(rbinom(n*P,prob=0.5,size=1), ncol=P)
S2 <- c(rep(1,n/2),rep(2,n/2))
historical <- list(list(time=time1, event=event1, X=X1, S=S1),
                   list(time=time2, event=event2, X=X2, S=S2))

n.subjects <- 100
n.events <- 30

# We choose three intervals for the first stratum and two intervals for the second stratum
n.intervals <- c(3,2) 

# Generate sampling priors

# The null hypothesis here is H0: beta_1 >= 0. To calculate power,
# we can provide samples of beta_1 such that the mass of beta_1 < 0.
# To calculate type I error, we can provide samples of beta_1 such that
# the mass of beta_1 >= 0.
samp.prior.beta1 <- rnorm(100, mean=-1, sd=1)
# Here, mass is put on the alternative region, so power is calculated.
samp.prior.beta <- cbind(samp.prior.beta1, matrix(rnorm(100*(P-1)), 100, P-1))

# Point mass sampling priors are used for lambda
lambda_strat1 <- matrix(c(0.5, 0.5, 0.5), nrow=1)
lambda_strat2 <- matrix(c(0.7, 0.7), nrow=1)
samp.prior.lambda <- list(lambda_strat1, lambda_strat2)


nMC <- 50 # nMC should be larger in practice
nBI <- 50
N <- 5 # N should be larger in practice

result <- power.phm.random.a0(historical=historical, n.subjects=n.subjects, 
                              n.events=n.events, n.intervals=n.intervals, 
                              samp.prior.beta=samp.prior.beta, 
                              samp.prior.lambda=samp.prior.lambda,
                              prior.a0.shape1 = c(1,1), prior.a0.shape2 = c(1,1),
                              dist.enroll="Uniform", param.enroll=0.5,
                              nMC=nMC, nBI=nBI, delta=0, nullspace.ineq=">", N=N)
result$`power/type I error`
result$`average posterior mean of beta`
result$`average posterior mean of lambda`



}
\references{
Ibrahim, J. G., Chen, M.-H. and Sinha, D. (2001). Bayesian Survival Analysis. New York: Springer Science & Business Media.

Psioda, M. A. and Ibrahim, J. G. (2019). Bayesian clinical trial design using historical data that inform the treatment effect. Biostatistics 20, 400–415.

Shen, Y., Psioda, M. A., and Joseph, J. G. (2023). BayesPPD: an R package for Bayesian sample size determination using the power and normalized power prior for generalized linear models. The R Journal, 14(4).
}
\seealso{
\code{\link{phm.random.a0}} and \code{\link{approximate.prior.beta}}
}
