% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_MCMC.R
\name{func_MCMC}
\alias{func_MCMC}
\title{Function to run MCMC sampling}
\usage{
func_MCMC(
  survObj,
  hyperpar,
  initial,
  nIter,
  thin,
  burnin,
  S,
  method,
  MRF_2b,
  MRF_G,
  output_graph_para,
  verbose
)
}
\arguments{
\item{survObj}{a list containing observed data from \code{n} subjects;
\code{t}, \code{di}, \code{X}. See details for more information}

\item{hyperpar}{a list containing prior parameter values}

\item{initial}{a list containing prior parameters' initial values}

\item{nIter}{the number of iterations of the chain}

\item{thin}{thinning MCMC intermediate results to be stored}

\item{burnin}{number of iterations to discard at the start of the chain.
Default is 0}

\item{S}{the number of subgroups}

\item{method}{a method option from
\code{c("Pooled", "CoxBVSSL", "Sub-struct")}}

\item{MRF_2b}{two different b in MRF prior for subgraphs G_ss and G_rs}

\item{MRF_G}{logical value. \code{MRF_G = TRUE} is to fix the MRF graph which
is provided in the argument \code{hyperpar}, and \code{MRF_G = FALSE} is to
use graphical model for leanring the MRF graph}

\item{output_graph_para}{allow (\code{TRUE}) or suppress (\code{FALSE}) the
output for parameters 'G', 'V', 'C' and 'Sig' in the graphical model
if \code{MRF_G = FALSE}}

\item{verbose}{logical value to display the progess of MCMC}
}
\value{
A list object saving the MCMC results with components including
'gamma.p', 'beta.p', 'h.p', 'gamma.margin', 'beta.margin', 's', 'eta0',
'kappa0', 'c0', 'pi.ga', 'tau', 'cb', 'accept.RW', 'log.jpost', 'log.like',
'post.gamma'
}
\description{
This an internal function for MCMC sampling
}
