% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFromJafroc.R
\name{convertFromJafroc}
\alias{convertFromJafroc}
\title{Convert from Jafroc formulation to formulation for this package to apply \code{fit_Bayesian_FROC()}}
\format{The xlsx file of Jafroc must include three sheets named by \strong{\emph{TP, FP, Truth}} (other names never be permitted !!)

A sheet named \strong{\emph{TP}}  includes five columns named from the right hand side:

\strong{\emph{ReaderID,	ModalityID,	CaseID,	LesionID,	TP_Rating.}}

1) Note that the above word CaseID means the Image ID vectors indicating the ID of radiographs.
   That is "case = image = radiograph".
2) Note that the first row of xlsx sheet devote for the names as follows:

\strong{An Example of a sheet named \emph{TP} in a \emph{xlsx} file for the \emph{Jafroc} software}

\tabular{ccccc}{
  ReaderID \tab   ModalityID   \tab   CaseID \tab   LesionID \tab   TP_Rating.\cr
  -------------------\tab-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab  1\tab 5\cr
  1 \tab 2 \tab 2  \tab 1\tab 4\cr
  1 \tab 3 \tab 4  \tab 1\tab 5\cr
  1 \tab 1 \tab 8  \tab 1\tab 3\cr
  1 \tab 2 \tab 8  \tab 2\tab 4\cr
  1 \tab 3 \tab 9  \tab 1\tab 4\cr
  1 \tab 1 \tab 9  \tab 2\tab 3\cr
  1 \tab 2 \tab 9  \tab 3\tab 5\cr
  1 \tab 3 \tab 11 \tab 1\tab 3\cr
  2 \tab 1 \tab 1 \tab  1\tab 4\cr
  2 \tab 2 \tab 4  \tab 1\tab 4\cr
  2 \tab 3 \tab 5  \tab 1\tab 4\cr
  2 \tab 1 \tab 8  \tab 1\tab 1\cr
  2 \tab 2 \tab 8  \tab 2\tab 2\cr
  2 \tab 3 \tab 8  \tab 3\tab 2\cr
  2 \tab 1 \tab 10  \tab 1\tab 3\cr
  2 \tab 2 \tab 10 \tab 2\tab 2\cr
  2 \tab 3 \tab 11  \tab 1\tab 2\cr

  : \tab : \tab :  \tab :\tab :\cr
  : \tab : \tab :  \tab :\tab :\cr    }


A sheet named \strong{FP}  includes four columns named from the right hand side: \strong{ReaderID,	ModalityID,	CaseID,	FP_Rating}
\strong{An Example of a sheet named FP in a xlsx file for the Jafroc software}

\tabular{cccc}{
  ReaderID \tab   ModalityID   \tab   CaseID  \tab   FP_Rating.\cr
-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab   2\cr
  1 \tab 2 \tab 2  \tab  1\cr
  1 \tab 3 \tab 3  \tab  1\cr
  1 \tab 1 \tab 5  \tab  2\cr
  1 \tab 2 \tab 7 \tab   1\cr
  1 \tab 3 \tab 7  \tab   2\cr
  1 \tab 1 \tab 9  \tab   3\cr
  1 \tab 2 \tab 9  \tab   4\cr
  1 \tab 3 \tab 10 \tab   1\cr
  2 \tab 1 \tab 1 \tab    2\cr
  2 \tab 2 \tab 2  \tab   3\cr
  2 \tab 3 \tab 3  \tab   4\cr
  2 \tab 1 \tab 8  \tab   1\cr
  2 \tab 2 \tab 9  \tab  1\cr
  2 \tab 3 \tab 11  \tab   1\cr
  2 \tab 1 \tab 14  \tab  1\cr
  2 \tab 2 \tab 15 \tab   1\cr
  2 \tab 3 \tab 21  \tab   2\cr
  : \tab :  \tab :\tab :\cr
  : \tab :  \tab :\tab :\cr
     }



A sheet named \strong{Truth }  includes three columns named from the right hand side:\strong{CaseID,	LesionID,	Weight} .

\strong{An Example of a sheet named Truth in a xlsx file for the Jafroc software}
\tabular{ccc}{
  CaseID \tab   LesionID   \tab     Weight\cr
  -------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab    0.3333...\cr
  1 \tab 2 \tab    0.3333...\cr
  1 \tab 3 \tab    0.3333...\cr
  2 \tab 1 \tab    0.5\cr
  2 \tab 2 \tab    0.5\cr
  3 \tab 1 \tab    1\cr
  4 \tab 1 \tab    0.25\cr
  4 \tab 2 \tab    0.25\cr
  4 \tab 3 \tab    0.25\cr
  4 \tab 4 \tab    0.25\cr
  5 \tab 1 \tab    0.5\cr
  5 \tab 2 \tab    0.5\cr
  6 \tab 1 \tab    0.3333...\cr
  6 \tab 2 \tab    0.3333...\cr
  6 \tab 3 \tab    0.3333...\cr
  7 \tab 1 \tab    0.3333...\cr
  7 \tab 2 \tab    0.3333...\cr
  7 \tab 3 \tab    0.3333...\cr
  8 \tab 1 \tab    0.25\cr
  8 \tab 2 \tab    0.25\cr
  8 \tab 3 \tab    0.25\cr
  8 \tab 4 \tab    0.25\cr
  :  \tab :\tab :\cr
  :  \tab :\tab :\cr
  }






Never change from these column names in any xlsx file.


Note that the weght are used for each images influence a same effect on the esimates.
If we consider the truth without weight, then the images including many targets (lesions) has very strong effect on the estimates.
To avoid such bias, Jafroc uses weight. However, in this package, we do not use the information of weight.
Since the theory of the author of this package did not consider such weight. In the future I have to include the notion of weight.
Jafroc use the notion fo figure of metric as non parametric manner.
So, it seems difficult to include it in the Bayesian model, since generally speaking, Bayesian methodology is parametric.}
\usage{
convertFromJafroc(No.of.Modalities, No.of.readers, No.of.confidence.levels)
}
\arguments{
\item{No.of.Modalities}{Total number of modalities used your data.}

\item{No.of.readers}{Total number of readers who are participants.}

\item{No.of.confidence.levels}{The number of confidence levels.}
}
\description{
Convert an Excel file whose extension is \strong{.xlsx} of Chakraborty's Jafroc formulation to
and Excel xlsx file of number of hits and false alarms formulation which is our required formulation.
}
\details{
The return values include the data list which are directly available to the main function \code{fit_Bayesian_FROC}.
So, if user has data of Jafroc, then by running this function, user immediately can fit the author's hierarchical Bayesian FROC model to the resulting R object.

The Jafroc software's format includes suspicious locations of readers and true locations.
Such data is redundant for our Bayesian statistical models. So, we reduce the information of data to the number of
false positives and number of hits for each confidence levels by this function.
}
\examples{

\donttest{

# PREPARATION:

# By an xlsx file named JAFROC_data.xlsx in the director "inst/extdata" of this package,
# we can reconstruct it  as follows:
# I do not know how to users refer the JAFROC_data.xlsx in this package,
# so I provide it by making the same xlsx file as the JAFROC_data.xlsx.


# Note that JAFROC_data.xlsx cannot remove,
# if it is removed, then devtools::run_examples() make an error.

Truth <- readxl::read_excel(system.file("extdata",
 "JAFROC_data.xlsx",
  package="BayesianFROC"),
   sheet = "Truth")
View(Truth)

TP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                       package="BayesianFROC"),
                           sheet = "TP")
View(TP)

FP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                        package="BayesianFROC"),
                          sheet = "FP")
View(FP)





sample <- list(TP=TP,FP=FP,Truth=Truth)
openxlsx::write.xlsx(sample,"JafrocDatasetExample.xlsx")




# Now, we get excel file named "JafrocDatasetExample.xlsx", which is same as
# the JAFROC_data.xlsx.
# whose format is available in the Jafroc software developed by Chakraborty.
# If you use your data, your data must has same format of "JafrocDatasetExample.xlsx".
# Note that other excel data must comply with the above format.

# Note that if you have proper format excel file for our package,
# this process does not need.




#    (0) From the above, we obtain  "JafrocDatasetExample.xlsx"
#    which is the multiple reader and multiple modality dataset
#    for Jfroc analysis which is NOT implemented in our package,
#     but Chakraborty's software called Jafroc or the R package Rjafroc.

# (1) Using "JafrocDatasetExample.xlsx" as an example excel file,
# we run the function to convert the excel file from Jafroc format
# to our format:



     dataList <- convertFromJafroc(
                                  No.of.Modalities =5,
                                  No.of.readers    =4,
                                  No.of.confidence.levels = 5
                                    )


#  (2)   Now, we obtain a data list as the return value.
#        Using this list, we run the function "fit_Bayesian_FROC":



     fit_Bayesian_FROC(dataList )


           } # dontrun

}
\references{
Bayesian Models for Free-response Receiver Operating Characteristic Analysis
}
\seealso{
Rjafroc
}
\author{
Issei Tsunoda
}
