% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{create_dataList_MRMC}
\alias{create_dataList_MRMC}
\title{MRMC: One Dataset Creator (No Replication)}
\usage{
create_dataList_MRMC(z.truth = BayesianFROC::z_truth,
  mu.truth = BayesianFROC::mu_truth, v.truth = BayesianFROC::v_truth,
  NI = 57, NL = 142, ModifiedPoisson = FALSE, seed = 123,
  summary = FALSE)
}
\arguments{
\item{z.truth}{Vector of dimension = C represents the thresholds of bi-normal assumption.}

\item{mu.truth}{array of dimension (M,Q). Mean of represents the signal distribution of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q). Standard Deviation of represents the signal distribution of bi-normal assumption.}

\item{NI}{The number of images,}

\item{NL}{The number of lesions,}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then False Positive Fraction (FPF) is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{seed}{The seed for creating hits which are generated by the binomial distributions with the specified seed.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\description{
From threshold, mean and S.D., data of Hits and  False Alarm are created.
}
\examples{
\donttest{
     dataList  <- create_dataList_MRMC()


     fit_Bayesian_FROC(dataList,summary = FALSE)


#  In the example, we use a default values for true parameters for
#  the distributions. The reason why the default values exists is difficulty
#  for the user who is not familiar with FROC data nor FROC model parameter regions.
#   So, in the Bayesian model is merely model for FROC data.
#   If user input the abnormal data, then the model does not fit nor converge
#   in the Hamiltonian Monte Carlo simulations.
}
}
