% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{z_from_dz}
\alias{z_from_dz}
\title{Thresholds from its difference}
\usage{
z_from_dz(w, dz)
}
\arguments{
\item{w}{a real number, indicating the first threshold}

\item{dz}{a vector of real numbers, indicating the difference of thresholds}
}
\value{
A vector of real numbers
}
\description{
Thresholds are created from its differece

 \deqn{z[1] = w }
 \deqn{z[2] = z[1]+ (z[2]-z[1] ) }
 \deqn{z[3] = z[1]+ (z[2]-z[1] )+(z[3]-z[2]) }
 \deqn{z[4] = z[1]+ (z[2]-z[1] )+(z[3]-z[2])+(z[4]-z[3]) }
}
\examples{

z_from_dz(1,c(2,3))

z_from_dz(1,c(0.2,0.03))

z_from_dz(1,c(0.2,0.03,0.004))




  dz <-runif(3,    # sample size
             0.01, # lower bound
             1     # upper bound
             )


  w  <- rnorm(1,
              0,
              1
              )

  z_from_dz(w,dz  )





}
