% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROC_data_creator2}
\alias{ROC_data_creator2}
\title{Synthesize ROC data}
\usage{
ROC_data_creator2(
  Number_of_cases = 100,
  Number_of_non_cases = 100,
  prob_case = c(0.1, 0.2, 0.3, 0.5),
  prob_non_case = c(0.4, 0.3, 0.2, 0.1),
  name = FALSE,
  seed = NA
)
}
\arguments{
\item{Number_of_cases}{Number_of_cases}

\item{Number_of_non_cases}{Number_of_non_cases}

\item{prob_case}{prob_case}

\item{prob_non_case}{prob_non_case}

\item{name}{A logical, whether name is given or not.}

\item{seed}{An integer, indicating seed}
}
\value{
A list, indicatin ROC data
}
\description{
Synthesize ROC data
}
\examples{

  d<-ROC_data_creator2()

\dontrun{
f<-fit_srsc_ROC(d,ite  = 111, summary = FALSE,  cha = 1,)
rstan::check_hmc_diagnostics(f)
rstan::traceplot(f)
draw_ROC_Curve_from_fitted_model(f)
}




d<-ROC_data_creator2(
  Number_of_cases = 100,
  Number_of_non_cases = 100,
  prob_case = c(0.1,0.2,0.3,0.5,0.8,0.9),
  prob_non_case = c(0.4,0.3,0.2,0.1,0.1,0.1)
  )
\dontrun{
f<-fit_srsc_ROC(d,ite  = 111, summary = FALSE,  cha = 1,)
rstan::check_hmc_diagnostics(f)
rstan::traceplot(f)
draw_ROC_Curve_from_fitted_model(f)
}








}
