/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.tutorial;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.loggers.Logger;
import dr.inference.loggers.MCLogger;
import dr.inference.mcmc.MCMC;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.ScaleOperator;
import dr.inference.trace.TraceAnalysis;
import dr.inference.trace.TraceException;
import dr.util.Attribute;
import java.io.IOException;

public class Tutorial1 {
    public static void main(String[] stringArray) throws IOException, TraceException {
        Variable.D d = new Variable.D("mean", 1.0);
        d.addBounds(new Parameter.DefaultBounds(1000.0, -1000.0, 1));
        Variable.D d2 = new Variable.D("stdev", 1.0);
        d2.addBounds(new Parameter.DefaultBounds(1000.0, 0.0, 1));
        NormalDistributionModel normalDistributionModel = new NormalDistributionModel(d, d2);
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood(normalDistributionModel);
        Attribute.Default<double[]> default_ = new Attribute.Default<double[]>("x", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        distributionLikelihood.addData(default_);
        ScaleOperator scaleOperator = new ScaleOperator(d, 0.75);
        ScaleOperator scaleOperator2 = new ScaleOperator(d2, 0.75);
        MCLogger mCLogger = new MCLogger(100L);
        mCLogger.add(d);
        mCLogger.add(d2);
        MCLogger mCLogger2 = new MCLogger("tutorial1.log", 100L, false, 0);
        mCLogger2.add(d);
        mCLogger2.add(d2);
        MCMC mCMC = new MCMC("tutorial1:normal");
        mCMC.init(100000L, (Likelihood)distributionLikelihood, new MCMCOperator[]{scaleOperator, scaleOperator2}, new Logger[]{mCLogger, mCLogger2});
        mCMC.chain();
        TraceAnalysis.report("tutorial1.log");
    }
}

