/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.FrequencyModel;

public class CovarionFrequencyModel
extends FrequencyModel {
    Parameter hiddenFrequencies;

    public CovarionFrequencyModel(DataType dataType, Parameter parameter, Parameter parameter2) {
        super(dataType, parameter);
        this.hiddenFrequencies = parameter2;
        this.addVariable(parameter2);
    }

    @Override
    public double[] getFrequencies() {
        int n = 0;
        int n2 = this.frequencyParameter.getDimension();
        int n3 = this.hiddenFrequencies.getDimension();
        double[] dArray = new double[n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[n] = this.frequencyParameter.getParameterValue(j) * this.hiddenFrequencies.getParameterValue(i);
                ++n;
            }
        }
        return dArray;
    }

    @Override
    public void setFrequency(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getFrequency(int n) {
        int n2 = this.frequencyParameter.getDimension();
        return this.frequencyParameter.getParameterValue(n % n2) * this.hiddenFrequencies.getParameterValue(n / n2);
    }

    @Override
    public int getFrequencyCount() {
        return this.frequencyParameter.getDimension() * this.hiddenFrequencies.getDimension();
    }
}

