/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.sequence;

import dr.evolution.sequence.Sequence;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UncertainSequence
extends Sequence {
    public static char openDelimitor = (char)123;
    public static char closeDelimitor = (char)125;
    public static String separateDelimitor = "|";
    public static String traitDelimitor = ":";
    public static char defaultAmbiguousChar = (char)63;
    private List<UncertainCharacterList> characters;
    private boolean isParsed = false;

    @Override
    public char getChar(int n) {
        this.checkParsed();
        UncertainCharacterList uncertainCharacterList = this.characters.get(n);
        if (uncertainCharacterList.size() == 1) {
            return ((UncertainCharacter)uncertainCharacterList.get(0)).getCharacter();
        }
        return defaultAmbiguousChar;
    }

    @Override
    public int getLength() {
        this.checkParsed();
        return this.characters.size();
    }

    @Override
    public int getState(int n) {
        this.checkParsed();
        UncertainCharacterList uncertainCharacterList = this.characters.get(n);
        if (uncertainCharacterList.size() == 1) {
            return this.dataType.getState(((UncertainCharacter)uncertainCharacterList.get(0)).getCharacter());
        }
        return this.dataType.getState(defaultAmbiguousChar);
    }

    @Override
    public void setState(int n, int n2) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int getInvalidChar() {
        this.checkParsed();
        char[] cArray = this.dataType.getValidChars();
        if (cArray != null) {
            String string = new String(cArray);
            int n = 0;
            for (UncertainCharacterList uncertainCharacterList : this.characters) {
                for (UncertainCharacter uncertainCharacter : uncertainCharacterList) {
                    if (uncertainCharacter.isValidCharacter(string)) continue;
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static boolean containsWeights(String string) {
        return string.indexOf(openDelimitor) != -1 && string.indexOf(closeDelimitor) != -1;
    }

    private void checkParsed() {
        if (!this.isParsed) {
            this.parseSequenceString();
        }
    }

    private void parseSequenceString() {
        this.characters = new ArrayList<UncertainCharacterList>();
        String string = this.sequenceString.toString();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = -1;
            if (c == openDelimitor) {
                n2 = string.indexOf(closeDelimitor, n);
            }
            UncertainCharacterList uncertainCharacterList = new UncertainCharacterList();
            if (n2 != -1) {
                String string2 = string.substring(n + 1, n2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, separateDelimitor);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, traitDelimitor);
                    String string4 = stringTokenizer2.nextToken();
                    String string5 = stringTokenizer2.nextToken();
                    uncertainCharacterList.add(new UncertainCharacter(string4.charAt(0), Double.valueOf(string5)));
                }
                n = n2 + 1;
            } else {
                uncertainCharacterList.add(new UncertainCharacter(c));
                ++n;
            }
            this.characters.add(uncertainCharacterList);
        }
        this.isParsed = true;
    }

    public double[] getUncertainPattern(int n) {
        double[] dArray = new double[this.dataType.getStateCount()];
        UncertainCharacterList uncertainCharacterList = this.characters.get(n);
        for (UncertainCharacter uncertainCharacter : uncertainCharacterList) {
            int[] nArray;
            for (int n2 : nArray = this.dataType.getStates(this.dataType.getState(uncertainCharacter.getCharacter()))) {
                dArray[n2] = uncertainCharacter.getWeight();
            }
        }
        return dArray;
    }

    private class UncertainCharacterList
    extends ArrayList<UncertainCharacter> {
        private UncertainCharacterList() {
        }
    }

    private class UncertainCharacter {
        char character;
        double weight;

        UncertainCharacter(char c) {
            this.character = c;
            this.weight = 1.0;
        }

        UncertainCharacter(char c, double d) {
            this.character = c;
            this.weight = d;
        }

        public boolean isValidCharacter(String string) {
            return string.indexOf(this.character) >= 0;
        }

        public char getCharacter() {
            return this.character;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

