/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.evolution.util.Taxon;
import dr.util.Identifiable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface TaxonList
extends Identifiable,
Iterable<Taxon> {
    public int getTaxonCount();

    public Taxon getTaxon(int var1);

    public String getTaxonId(int var1);

    public int getTaxonIndex(String var1);

    public int getTaxonIndex(Taxon var1);

    public List<Taxon> asList();

    public Object getTaxonAttribute(int var1, String var2);

    public static class MissingTaxonException
    extends Exception {
        private static final long serialVersionUID = 1864895946392309485L;

        public MissingTaxonException(String string) {
            super(string);
        }
    }

    public static class MissingAttributeException
    extends Exception {
        public MissingAttributeException(String string) {
            super(string);
        }
    }

    public static class Utils {
        public static boolean hasAttribute(TaxonList taxonList, int n, String string) {
            return taxonList.getTaxonAttribute(n, string) != null;
        }

        public static Set<String> getTaxonListIdSet(TaxonList taxonList) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
                hashSet.add(taxonList.getTaxonId(i));
            }
            return hashSet;
        }

        public static int findDuplicateTaxon(TaxonList taxonList) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
                Taxon taxon = taxonList.getTaxon(i);
                if (hashSet.contains(taxon.getId())) {
                    return i;
                }
                hashSet.add(taxon.getId());
            }
            return -1;
        }

        public static boolean areTaxaIdentical(TaxonList taxonList, TaxonList taxonList2) {
            if (taxonList.getTaxonCount() != taxonList2.getTaxonCount()) {
                return false;
            }
            for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
                if (taxonList2.getTaxonIndex(taxonList.getTaxon(i)) != -1) continue;
                return false;
            }
            return true;
        }
    }
}

