/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evomodel.antigenic.phyloclustering.misc.obsolete.ClusterWalkOperator;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ClusterWalkOperatorParser
extends AbstractXMLObjectParser {
    public static final String CLUSTER_WALK_OPERATOR = "ClusterWalkOperator";
    public static final String WINDOW_SIZE = "windowSize";
    public static final String UPDATE_INDEX = "updateIndex";
    public static final String UPPER = "upper";
    public static final String LOWER = "lower";
    public static final String BOUNDARY_CONDITION = "boundaryCondition";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("windowSize"), AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("lower", true), AttributeRule.newDoubleRule("upper", true), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule("updateIndex", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), new StringAttributeRule("boundaryCondition", null, ClusterWalkOperator.BoundaryCondition.values(), true), new ElementRule(Parameter.class)};

    @Override
    public String getParserName() {
        System.out.println("Yo!");
        return CLUSTER_WALK_OPERATOR;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
        double d = xMLObject.getDoubleAttribute("weight");
        double d2 = xMLObject.getDoubleAttribute(WINDOW_SIZE);
        Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
        Double d3 = null;
        Double d4 = null;
        if (xMLObject.hasAttribute(LOWER)) {
            d3 = xMLObject.getDoubleAttribute(LOWER);
        }
        if (xMLObject.hasAttribute(UPPER)) {
            d4 = xMLObject.getDoubleAttribute(UPPER);
        }
        ClusterWalkOperator.BoundaryCondition boundaryCondition = ClusterWalkOperator.BoundaryCondition.valueOf(xMLObject.getAttribute(BOUNDARY_CONDITION, ClusterWalkOperator.BoundaryCondition.reflecting.name()));
        if (xMLObject.hasChildNamed(UPDATE_INDEX)) {
            XMLObject xMLObject2 = xMLObject.getChild(UPDATE_INDEX);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            if (parameter2.getDimension() != parameter.getDimension()) {
                throw new RuntimeException("Parameter to update and missing indices must have the same dimension");
            }
            return new ClusterWalkOperator(parameter, parameter2, d2, boundaryCondition, d, adaptationMode, d3, d4);
        }
        return new ClusterWalkOperator(parameter, null, d2, boundaryCondition, d, adaptationMode, d3, d4);
    }

    @Override
    public String getParserDescription() {
        return "This element returns a cluster walk operator on a given parameter.";
    }

    @Override
    public Class getReturnType() {
        return MCMCOperator.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

