/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DriftedTreeClusterLocationsStatistic
extends Statistic.Abstract
implements VariableListener {
    public static final String DRIFTED_TREE_CLUSTER_LOCATIONS_STATISTIC = "driftedTreeClusterLocationsStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String LOCATIONS = "locations";
        public static final String MU1_SCALE_PARAMETER = "mu1Scale";
        public static final String MU2_SCALE_PARAMETER = "mu2Scale";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("locations", MatrixParameter.class), new ElementRule("mu1Scale", Parameter.class, "Optional parameter for scaling the first dimension of mu"), new ElementRule("mu2Scale", Parameter.class, "Optional parameter for scaling the second dimension of mu")};

        @Override
        public String getParserName() {
            return DriftedTreeClusterLocationsStatistic.DRIFTED_TREE_CLUSTER_LOCATIONS_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = null;
            if (xMLObject.hasChildNamed(MU1_SCALE_PARAMETER)) {
                parameter = (Parameter)xMLObject.getElementFirstChild(MU1_SCALE_PARAMETER);
            }
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(MU2_SCALE_PARAMETER)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(MU2_SCALE_PARAMETER);
            }
            return new DriftedTreeClusterLocationsStatistic(matrixParameter, parameter, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return DriftedTreeClusterLocationsStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private MatrixParameter locationsParameter;
    private Parameter mu1ScaleParameter;
    private Parameter mu2ScaleParameter;

    public DriftedTreeClusterLocationsStatistic(MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2) {
        this.locationsParameter = matrixParameter;
        matrixParameter.addParameterListener(this);
        this.mu1ScaleParameter = parameter;
        this.mu1ScaleParameter.addParameterListener(this);
        this.mu2ScaleParameter = parameter2;
        this.mu2ScaleParameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.locationsParameter.getDimension();
    }

    public int getColumnIndex(int n) {
        return n / this.locationsParameter.getRowDimension();
    }

    public int getRowIndex(int n) {
        int n2 = this.getColumnIndex(n);
        return n - n2 * this.locationsParameter.getRowDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = this.getColumnIndex(n);
        int n3 = this.getRowIndex(n);
        Parameter parameter = this.locationsParameter.getParameter(n2);
        double d = n3 == 0 ? parameter.getParameterValue(n3) * this.mu1ScaleParameter.getParameterValue(0) : parameter.getParameterValue(n3) * this.mu2ScaleParameter.getParameterValue(0);
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        return this.locationsParameter.getDimensionName(n);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

