/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.BranchSpecificSubstitutionModelProvider;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.BranchParameter;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;

public class ArbitrarySubstitutionParameterBranchModel
extends AbstractModel
implements BranchModel,
TreeTraitProvider {
    private final BranchSpecificSubstitutionModelProvider substitutionModelProvider;
    protected final List<BranchParameter> substitutionParameterList;
    private int parameterDimension;
    private final TreeModel tree;
    private final TreeParameterModel parameterIndexHelper;
    private final TreeTraitProvider.Helper traitProvider = new TreeTraitProvider.Helper();

    public ArbitrarySubstitutionParameterBranchModel(String string, BranchSpecificSubstitutionModelProvider branchSpecificSubstitutionModelProvider, List<BranchParameter> list, TreeModel treeModel) {
        super(string);
        this.substitutionModelProvider = branchSpecificSubstitutionModelProvider;
        this.tree = treeModel;
        this.parameterIndexHelper = new TreeParameterModel(treeModel, new Parameter.Default(list.get(0).getDimension()), true);
        for (SubstitutionModel identifiable : branchSpecificSubstitutionModelProvider.getSubstitutionModelList()) {
            this.addModel(identifiable);
        }
        this.substitutionParameterList = list;
        this.parameterDimension = list.get(0).getDimension();
        for (BranchParameter branchParameter : list) {
            this.addVariable(branchParameter);
            this.traitProvider.addTrait(new SubstitutionParameterTrait(branchParameter.getId(), branchParameter, this.parameterIndexHelper));
            assert (branchParameter.getDimension() == this.parameterDimension);
        }
    }

    public void addSubstitutionParameter(BranchParameter branchParameter) {
        if (branchParameter.getDimension() != this.parameterDimension) {
            throw new RuntimeException("Wrong dimension of the new BranchSpecificSubstitutionParameter.");
        }
        this.substitutionParameterList.add(branchParameter);
        this.addVariable(branchParameter);
    }

    public Parameter getSubstitutionParameterForBranch(NodeRef nodeRef, BranchParameter branchParameter) {
        if (!this.substitutionParameterList.contains(branchParameter)) {
            throw new RuntimeException("The branch parameter is not in the substitution parameter list.");
        }
        return branchParameter.getParameter(this.parameterIndexHelper.getParameterIndexFromNodeNumber(nodeRef.getNumber()));
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        return this.substitutionModelProvider.getBranchModelMapping(nodeRef);
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModelProvider.getSubstitutionModelList();
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        return this.substitutionModelProvider.getRootSubstitutionModel();
    }

    public SubstitutionModel getSubstitutionModelForBranch(NodeRef nodeRef) {
        return this.substitutionModelProvider.getSubstitutionModel(this.tree, nodeRef);
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged(object, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.traitProvider.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.traitProvider.getTreeTrait(string);
    }

    private class SubstitutionParameterTrait
    implements TreeTrait<Double> {
        private Parameter substitutionParameter;
        private String traitName;
        private TreeParameterModel parameterIndexHelper;

        private SubstitutionParameterTrait(String string, Parameter parameter, TreeParameterModel treeParameterModel) {
            this.substitutionParameter = parameter;
            this.traitName = string;
            this.parameterIndexHelper = treeParameterModel;
        }

        @Override
        public String getTraitName() {
            return this.traitName;
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.BRANCH;
        }

        @Override
        public Class getTraitClass() {
            return CompoundParameter.class;
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            return this.substitutionParameter.getParameterValue(this.parameterIndexHelper.getParameterIndexFromNodeNumber(nodeRef.getNumber()));
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return this.getTrait(tree, nodeRef).toString();
        }

        @Override
        public boolean getLoggable() {
            return true;
        }
    }
}

