/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.Intervals;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeIntervals
extends AbstractModel
implements Units,
IntervalList {
    private Tree tree = null;
    private Set<String> includedLeafSet = null;
    private Set[] excludedLeafSets = null;
    private Intervals intervals = null;
    private Intervals storedIntervals = null;
    private boolean eventsKnown = false;
    private boolean storedEventsKnown = false;

    public TreeIntervals(Tree tree, TaxonList taxonList, List<TaxonList> list) throws TreeUtils.MissingTaxonException {
        super("TreeIntervals");
        this.tree = tree;
        if (taxonList != null) {
            this.includedLeafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        }
        if (list != null && list.size() > 0) {
            this.excludedLeafSets = new Set[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.excludedLeafSets[i] = TreeUtils.getLeavesForTaxa(tree, list.get(i));
            }
        } else {
            this.excludedLeafSets = null;
        }
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.intervals = new Intervals(tree.getNodeCount());
        this.storedIntervals = new Intervals(tree.getNodeCount());
        this.eventsKnown = false;
        this.addStatistic(new DeltaStatistic());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.eventsKnown = false;
        }
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedIntervals.copyIntervals(this.intervals);
        this.storedEventsKnown = this.eventsKnown;
    }

    @Override
    protected void restoreState() {
        Intervals intervals = this.storedIntervals;
        this.storedIntervals = this.intervals;
        this.intervals = intervals;
        this.eventsKnown = this.storedEventsKnown;
    }

    @Override
    protected final void acceptState() {
    }

    public final Model getModel() {
        return this;
    }

    private NodeRef getIncludedMRCA(Tree tree) {
        if (this.includedLeafSet != null) {
            return TreeUtils.getCommonAncestorNode(tree, this.includedLeafSet);
        }
        return tree.getRoot();
    }

    private Set<NodeRef> getExcludedMRCAs(Tree tree) {
        if (this.excludedLeafSets.length == 0) {
            return null;
        }
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        for (Set set : this.excludedLeafSets) {
            hashSet.add(TreeUtils.getCommonAncestorNode(tree, set));
        }
        return hashSet;
    }

    public Tree getTree() {
        return this.tree;
    }

    public IntervalList getIntervals() {
        return this.intervals;
    }

    @Override
    public final void calculateIntervals() {
        this.intervals.resetEvents();
        if (this.includedLeafSet != null || this.excludedLeafSets != null) {
            this.collectTimes(this.tree, this.getIncludedMRCA(this.tree), this.getExcludedMRCAs(this.tree), this.intervals);
        } else {
            this.collectTimes(this.tree, this.intervals);
        }
        this.intervals.getIntervalCount();
        this.eventsKnown = true;
    }

    private void collectTimes(Tree tree, NodeRef nodeRef, Set<NodeRef> set, Intervals intervals) {
        intervals.addCoalescentEvent(tree.getNodeHeight(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            boolean bl = true;
            if (set != null && set.contains(nodeRef2)) {
                bl = false;
            }
            if (!bl || tree.isExternal(nodeRef2)) {
                intervals.addSampleEvent(tree.getNodeHeight(nodeRef2));
                continue;
            }
            this.collectTimes(tree, nodeRef2, set, intervals);
        }
    }

    private void collectTimes(Tree tree, Intervals intervals) {
        int n;
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            intervals.addSampleEvent(tree.getNodeHeight(tree.getExternalNode(n)));
        }
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            intervals.addCoalescentEvent(tree.getNodeHeight(tree.getInternalNode(n)));
        }
    }

    @Override
    public double getStartTime() {
        return this.intervals.getStartTime();
    }

    @Override
    public int getIntervalCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalCount();
    }

    @Override
    public int getSampleCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getSampleCount();
    }

    @Override
    public double getInterval(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getInterval(n);
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalTime(n);
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.getIntervalCount()) {
            throw new IllegalArgumentException();
        }
        return this.intervals.getLineageCount(n);
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getCoalescentEvents(n);
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalType(n);
    }

    @Override
    public double getTotalDuration() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getTotalDuration();
    }

    @Override
    public boolean isBinaryCoalescent() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.isBinaryCoalescent();
    }

    @Override
    public boolean isCoalescentOnly() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.isCoalescentOnly();
    }

    @Override
    public Units.Type getUnits() {
        return this.intervals.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.intervals.setUnits(type);
    }

    public class DeltaStatistic
    extends Statistic.Abstract {
        public DeltaStatistic() {
            super("delta");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            throw new RuntimeException("Not implemented");
        }
    }
}

