/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.PiecewiseConstantPopulation;
import dr.evolution.coalescent.PiecewiseLinearPopulation;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;

public class ScaledPiecewiseModel
extends DemographicModel {
    Parameter N0Parameter;
    TreeModel treeModel;
    PiecewiseConstantPopulation piecewiseFunction = null;

    public ScaledPiecewiseModel(Parameter parameter, TreeModel treeModel, boolean bl, Units.Type type) {
        this("scaledPiecewisePopulation", parameter, treeModel, bl, type);
    }

    public ScaledPiecewiseModel(String string, Parameter parameter, TreeModel treeModel, boolean bl, Units.Type type) {
        super(string);
        if (parameter.getDimension() < 2) {
            throw new IllegalArgumentException("Must have at least 2 epochs");
        }
        this.N0Parameter = parameter;
        this.treeModel = treeModel;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.setUnits(type);
        int n = parameter.getDimension();
        this.piecewiseFunction = bl ? new PiecewiseLinearPopulation(new double[n - 1], new double[n], type) : new PiecewiseConstantPopulation(new double[n - 1], new double[n], type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d = this.treeModel.getNodeHeight(this.treeModel.getRoot());
        int n = this.N0Parameter.getDimension();
        for (int i = 0; i < this.N0Parameter.getDimension(); ++i) {
            this.piecewiseFunction.setArgument(i, this.N0Parameter.getParameterValue(i));
            if (i >= n - 1) continue;
            this.piecewiseFunction.setEpochDuration(i, d / (double)n);
        }
        return this.piecewiseFunction;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    protected void handleParameterChangedEvent(Parameter parameter, int n) {
        if (parameter == this.N0Parameter) {
            // empty if block
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

