/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;

public class TransmissionExchangeOperatorB
extends AbstractTreeOperator {
    private final CaseToCaseTreeLikelihood c2cLikelihood;
    public static final String TRANSMISSION_EXCHANGE_OPERATOR_B = "transmissionExchangeOperatorB";
    private final boolean resampleInfectionTimes;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public String getParserName() {
            return TransmissionExchangeOperatorB.TRANSMISSION_EXCHANGE_OPERATOR_B;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            if (caseToCaseTreeLikelihood.getTreeModel().getExternalNodeCount() <= 2) {
                throw new XMLParseException("Tree with fewer than 3 taxa");
            }
            double d = xMLObject.getDoubleAttribute("weight");
            boolean bl = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            return new TransmissionExchangeOperatorB(caseToCaseTreeLikelihood, d, bl);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a exchange operator, swapping two random subtrees in such a way that subtrees of the transmission tree are also exchanged.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionExchangeOperatorB.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TransmissionExchangeOperatorB(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, boolean bl) {
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.setWeight(d);
        this.resampleInfectionTimes = bl;
    }

    @Override
    public double doOperation() {
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        double d = this.exchange();
        int n = partitionedTreeModel.getExternalNodeCount();
        assert (partitionedTreeModel.getExternalNodeCount() == n) : "Lost some tips";
        return d;
    }

    public double exchange() {
        Serializable serializable;
        Serializable serializable2;
        NodeRef nodeRef;
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        int n = partitionedTreeModel.getNodeCount();
        NodeRef nodeRef2 = nodeRef = partitionedTreeModel.getRoot();
        NodeRef nodeRef3 = partitionedTreeModel.getParent(nodeRef2);
        boolean bl = true;
        while (nodeRef == nodeRef2 || bl) {
            nodeRef2 = partitionedTreeModel.getNode(MathUtils.nextInt(n));
            nodeRef3 = partitionedTreeModel.getParent(nodeRef2);
            bl = nodeRef2 == nodeRef || branchMapModel.get(nodeRef2.getNumber()) == branchMapModel.get(nodeRef3.getNumber());
        }
        ArrayList<NodeRef> arrayList = this.getPossibleExchanges(partitionedTreeModel, nodeRef2);
        int n2 = arrayList.size();
        if (n2 == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        NodeRef nodeRef4 = arrayList.get(MathUtils.nextInt(arrayList.size()));
        int n3 = this.getPossibleExchanges(partitionedTreeModel, nodeRef4).size();
        double d = 1.0 / (double)n2 + 1.0 / (double)n3;
        NodeRef nodeRef5 = partitionedTreeModel.getParent(nodeRef4);
        if (this.resampleInfectionTimes) {
            serializable2 = branchMapModel.get(nodeRef2.getNumber());
            serializable = branchMapModel.get(nodeRef4.getNumber());
            ((AbstractCase)serializable2).setInfectionBranchPosition(MathUtils.nextDouble());
            ((AbstractCase)serializable).setInfectionBranchPosition(MathUtils.nextDouble());
        }
        this.exchangeNodes(partitionedTreeModel, nodeRef2, nodeRef4, nodeRef3, nodeRef5);
        serializable2 = this.getPossibleExchanges(partitionedTreeModel, nodeRef2);
        serializable = this.getPossibleExchanges(partitionedTreeModel, nodeRef4);
        double d2 = 1.0 / (double)((ArrayList)serializable2).size() + 1.0 / (double)((ArrayList)serializable).size();
        return Math.log(d2 / d);
    }

    public ArrayList<NodeRef> getPossibleExchanges(TreeModel treeModel, NodeRef nodeRef) {
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        if (nodeRef2 == null) {
            throw new RuntimeException("Can't exchange the root node");
        }
        if (branchMapModel.get(nodeRef2.getNumber()) == branchMapModel.get(nodeRef.getNumber())) {
            throw new RuntimeException("This node is not exchangeable by this operator");
        }
        for (NodeRef nodeRef3 : treeModel.getNodes()) {
            NodeRef nodeRef4 = treeModel.getParent(nodeRef3);
            if (nodeRef4 == nodeRef2 || nodeRef4 == null || nodeRef3 == nodeRef2 || nodeRef == nodeRef4 || !(treeModel.getNodeHeight(nodeRef3) < treeModel.getNodeHeight(nodeRef2)) || !(treeModel.getNodeHeight(nodeRef) < treeModel.getNodeHeight(nodeRef4)) || branchMapModel.get(nodeRef4.getNumber()) == branchMapModel.get(nodeRef3.getNumber())) continue;
            if (arrayList.contains(nodeRef3) || nodeRef3 == nodeRef) {
                throw new RuntimeException("Adding a candidate that already exists in the list or the node itself");
            }
            arrayList.add(nodeRef3);
        }
        return arrayList;
    }

    public String getPerformanceSuggestion() {
        return "Not implemented";
    }

    @Override
    public String getOperatorName() {
        return "Transmission tree exchange operator type B (" + this.c2cLikelihood.getTreeModel().getId() + ")";
    }
}

