/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TransmissionWilsonBaldingB
extends AbstractTreeOperator {
    private final CaseToCaseTreeLikelihood c2cLikelihood;
    public static final String TRANSMISSION_WILSON_BALDING_B = "transmissionWilsonBaldingB";
    private double logq;
    private static final boolean DEBUG = false;
    private final int tipCount;
    private final boolean resampleInfectionTimes;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public String getParserName() {
            return TransmissionWilsonBaldingB.TRANSMISSION_WILSON_BALDING_B;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            boolean bl = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            return new TransmissionWilsonBaldingB(caseToCaseTreeLikelihood, d, bl);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a Wilson-Balding move operator, such that the transplantation of the phylogenetic subtree is also transplantation of a transmission subtree.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionWilsonBaldingB.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TransmissionWilsonBaldingB(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, boolean bl) {
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.setWeight(d);
        this.tipCount = caseToCaseTreeLikelihood.getTreeModel().getExternalNodeCount();
        this.resampleInfectionTimes = bl;
    }

    @Override
    public double doOperation() {
        this.proposeTree();
        if (this.c2cLikelihood.getTreeModel().getExternalNodeCount() != this.tipCount) {
            int n = this.c2cLikelihood.getTreeModel().getExternalNodeCount();
            throw new RuntimeException("Lost some tips in modified SPR! (" + this.tipCount + "-> " + n + ")");
        }
        return this.logq;
    }

    public void proposeTree() {
        NodeRef nodeRef;
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        int n = partitionedTreeModel.getNodeCount();
        while (!this.eligibleForMove(nodeRef = partitionedTreeModel.getNode(MathUtils.nextInt(n)), partitionedTreeModel, branchMapModel)) {
        }
        NodeRef nodeRef2 = partitionedTreeModel.getParent(nodeRef);
        NodeRef nodeRef3 = partitionedTreeModel.getNode(MathUtils.nextInt(partitionedTreeModel.getNodeCount()));
        NodeRef nodeRef4 = partitionedTreeModel.getParent(nodeRef3);
        while (nodeRef4 != null && partitionedTreeModel.getNodeHeight(nodeRef4) <= partitionedTreeModel.getNodeHeight(nodeRef) || nodeRef == nodeRef3) {
            nodeRef3 = partitionedTreeModel.getNode(MathUtils.nextInt(partitionedTreeModel.getNodeCount()));
            nodeRef4 = partitionedTreeModel.getParent(nodeRef3);
        }
        if (nodeRef2 == partitionedTreeModel.getRoot() || nodeRef3 == partitionedTreeModel.getRoot()) {
            this.logq = Double.NEGATIVE_INFINITY;
            return;
        }
        if (nodeRef4 == nodeRef2 || nodeRef3 == nodeRef2 || nodeRef4 == nodeRef) {
            this.logq = Double.NEGATIVE_INFINITY;
            return;
        }
        NodeRef nodeRef5 = this.getOtherChild(partitionedTreeModel, nodeRef2, nodeRef);
        NodeRef nodeRef6 = partitionedTreeModel.getParent(nodeRef2);
        if (this.resampleInfectionTimes) {
            AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
            AbstractCase abstractCase2 = branchMapModel.get(nodeRef2.getNumber());
            AbstractCase abstractCase3 = branchMapModel.get(nodeRef5.getNumber());
            AbstractCase abstractCase4 = null;
            if (nodeRef6 != null) {
                abstractCase4 = branchMapModel.get(nodeRef6.getNumber());
            }
            if (abstractCase != abstractCase2) {
                abstractCase.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            if (abstractCase4 == null || abstractCase3 != abstractCase4) {
                abstractCase3.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            AbstractCase abstractCase5 = branchMapModel.get(nodeRef3.getNumber());
            abstractCase5.setInfectionBranchPosition(MathUtils.nextDouble());
        }
        double d = Math.max(partitionedTreeModel.getNodeHeight(nodeRef), partitionedTreeModel.getNodeHeight(nodeRef3));
        double d2 = partitionedTreeModel.getNodeHeight(nodeRef4) - d;
        double d3 = d + MathUtils.nextDouble() * d2;
        double d4 = Math.max(partitionedTreeModel.getNodeHeight(nodeRef), partitionedTreeModel.getNodeHeight(nodeRef5));
        double d5 = partitionedTreeModel.getNodeHeight(nodeRef6) - d4;
        double d6 = d2 / Math.abs(d5);
        if (branchMapModel.get(nodeRef6.getNumber()) != branchMapModel.get(nodeRef5.getNumber())) {
            d6 *= 0.5;
        }
        if (branchMapModel.get(nodeRef4.getNumber()) != branchMapModel.get(nodeRef3.getNumber())) {
            d6 *= 2.0;
        }
        partitionedTreeModel.beginTreeEdit();
        if (nodeRef3 == partitionedTreeModel.getRoot()) {
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef2, nodeRef5);
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef6, nodeRef2);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef2, nodeRef3);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef6, nodeRef5);
            partitionedTreeModel.setRoot(nodeRef2);
        } else if (nodeRef2 == partitionedTreeModel.getRoot()) {
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef4, nodeRef3);
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef2, nodeRef5);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef2, nodeRef3);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef4, nodeRef2);
            partitionedTreeModel.setRoot(nodeRef5);
        } else {
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef4, nodeRef3);
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef2, nodeRef5);
            ((TreeModel)partitionedTreeModel).removeChild(nodeRef6, nodeRef2);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef2, nodeRef3);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef4, nodeRef2);
            ((TreeModel)partitionedTreeModel).addChild(nodeRef6, nodeRef5);
        }
        ((TreeModel)partitionedTreeModel).setNodeHeight(nodeRef2, d3);
        ((TreeModel)partitionedTreeModel).endTreeEdit();
        this.logq = Math.log(d6);
        if (MathUtils.nextInt(2) == 0) {
            branchMapModel.set(nodeRef2.getNumber(), branchMapModel.get(nodeRef4.getNumber()), true);
        } else {
            branchMapModel.set(nodeRef2.getNumber(), branchMapModel.get(nodeRef3.getNumber()), true);
        }
    }

    public String getPerformanceSuggestion() {
        return "Not implemented";
    }

    private boolean eligibleForMove(NodeRef nodeRef, TreeModel treeModel, BranchMapModel branchMapModel) {
        return !treeModel.isRoot(nodeRef) && branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) != branchMapModel.get(nodeRef.getNumber());
    }

    @Override
    public String getOperatorName() {
        return "transmissionWilsonBaldingB (" + this.c2cLikelihood.getTreeModel().getId() + ")";
    }
}

