/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.io.Importer;
import dr.evolution.io.TreeImporter;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Statistic;
import dr.math.MathUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class EmpiricalTreeDistributionModel
extends TreeModel {
    public static final String EMPIRICAL_TREE_DISTRIBUTION_MODEL = "empiricalTreeDistributionModel";
    private final Tree[] trees;
    private final TreeImporter importer;
    private Tree currentTree;
    private Tree storedCurrentTree;
    private int currentTreeIndex;

    public EmpiricalTreeDistributionModel(Tree[] treeArray, int n) {
        this(treeArray, null, n);
    }

    public EmpiricalTreeDistributionModel(TreeImporter treeImporter, int n) {
        this(null, treeImporter, n);
    }

    private EmpiricalTreeDistributionModel(Tree[] treeArray, TreeImporter treeImporter, int n) {
        super(EMPIRICAL_TREE_DISTRIBUTION_MODEL);
        this.trees = treeArray;
        this.importer = treeImporter;
        this.drawTreeIndex(n);
        this.addStatistic(new Statistic.Abstract("Current Tree"){

            @Override
            public int getDimension() {
                return 1;
            }

            @Override
            public double getStatisticValue(int n) {
                return EmpiricalTreeDistributionModel.this.currentTreeIndex;
            }
        });
    }

    @Override
    protected void storeState() {
        this.storedCurrentTree = this.currentTree;
    }

    @Override
    protected void restoreState() {
        this.currentTree = this.storedCurrentTree;
    }

    @Override
    protected void acceptState() {
    }

    public void drawTreeIndex() {
        this.drawTreeIndex(-1);
    }

    private void drawTreeIndex(int n) {
        if (this.importer != null) {
            try {
                if (!this.importer.hasTree()) {
                    throw new RuntimeException("EmpiricalTreeDistributionModel has run out of trees");
                }
                this.currentTree = this.importer.importNextTree();
            }
            catch (IOException iOException) {
                throw new RuntimeException("EmpiricalTreeDistributionModel unable to load next tree");
            }
            catch (Importer.ImportException importException) {
                throw new RuntimeException("EmpiricalTreeDistributionModel unable to load next tree");
            }
            ++this.currentTreeIndex;
        } else if (n == -1) {
            this.currentTreeIndex = MathUtils.nextInt(this.trees.length);
            this.currentTree = this.trees[this.currentTreeIndex];
        } else {
            this.currentTreeIndex = n;
            this.currentTree = this.trees[this.currentTreeIndex];
        }
        this.currentTree.getNodeHeight(this.currentTree.getRoot());
        this.fireModelChanged(new TreeModel.TreeChangedEvent(this));
    }

    @Override
    public NodeRef getRoot() {
        return this.currentTree.getRoot();
    }

    @Override
    public int getNodeCount() {
        return this.currentTree.getNodeCount();
    }

    @Override
    public NodeRef getNode(int n) {
        return this.currentTree.getNode(n);
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.currentTree.getInternalNode(n);
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.currentTree.getExternalNode(n);
    }

    @Override
    public int getExternalNodeCount() {
        return this.currentTree.getExternalNodeCount();
    }

    @Override
    public int getInternalNodeCount() {
        return this.currentTree.getInternalNodeCount();
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return this.trees[this.currentTreeIndex].getNodeTaxon(nodeRef);
    }

    @Override
    public boolean hasNodeHeights() {
        return this.currentTree.hasNodeHeights();
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.currentTree.getNodeHeight(nodeRef);
    }

    @Override
    public boolean hasBranchLengths() {
        return this.currentTree.hasBranchLengths();
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        return this.currentTree.getBranchLength(nodeRef);
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return this.currentTree.getNodeRate(nodeRef);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return this.currentTree.getNodeAttribute(nodeRef, string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return this.currentTree.getNodeAttributeNames(nodeRef);
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return this.currentTree.isExternal(nodeRef);
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return this.currentTree.isRoot(nodeRef);
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return this.currentTree.getChildCount(nodeRef);
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.currentTree.getChild(nodeRef, n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return this.currentTree.getParent(nodeRef);
    }

    @Override
    public Tree getCopy() {
        return this.currentTree.getCopy();
    }

    @Override
    public int getTaxonCount() {
        return this.currentTree.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.currentTree.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.currentTree.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.currentTree.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.currentTree.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        return this.currentTree.asList();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.currentTree.getTaxonAttribute(n, string);
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.currentTree.iterator();
    }

    @Override
    public Units.Type getUnits() {
        return this.currentTree.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.currentTree.setUnits(type);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.currentTree.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        return this.currentTree.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.currentTree.getAttributeNames();
    }
}

