/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.TreeScaledRepeatedMeasuresTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.evomodelxml.treelikelihood.TreeTraitParserUtilities;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.missingData.MissingOps;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RepeatedMeasuresTraitDataModel
extends ContinuousTraitDataModel
implements ContinuousTraitPartialsProvider,
ModelExtensionProvider.NormalExtensionProvider {
    private final String traitName;
    private final MatrixParameterInterface samplingPrecisionParameter;
    private boolean diagonalOnly = false;
    private boolean variableChanged = true;
    private boolean varianceKnown = false;
    private Matrix samplingPrecision;
    private Matrix samplingVariance;
    private Matrix storedSamplingPrecision;
    private Matrix storedSamplingVariance;
    private boolean storedVarianceKnown = false;
    private boolean storedVariableChanged = true;
    private boolean[] missingTraitIndicators = null;
    private static final boolean DEBUG = false;
    public static final String REPEATED_MEASURES_MODEL = "repeatedMeasuresModel";
    private static final String PRECISION = "samplingPrecision";
    private static final String SCALE_BY_TIP_HEIGHT = "scaleByTipHeight";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CholeskyDecomposition choleskyDecomposition;
            MutableTreeModel mutableTreeModel = (MutableTreeModel)xMLObject.getChild(TreeModel.class);
            TreeTraitParserUtilities treeTraitParserUtilities = new TreeTraitParserUtilities();
            TreeTraitParserUtilities.TraitsAndMissingIndices traitsAndMissingIndices = treeTraitParserUtilities.parseTraitsFromTaxonAttributes(xMLObject, (Tree)mutableTreeModel, true);
            CompoundParameter compoundParameter = traitsAndMissingIndices.traitParameter;
            boolean[] blArray = traitsAndMissingIndices.getMissingIndicators();
            XMLObject xMLObject2 = xMLObject.getChild(RepeatedMeasuresTraitDataModel.PRECISION);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject2.getChild(MatrixParameterInterface.class);
            try {
                choleskyDecomposition = new CholeskyDecomposition(matrixParameterInterface.getParameterAsMatrix());
            }
            catch (IllegalDimension illegalDimension) {
                throw new XMLParseException("samplingPrecision must be a square matrix.");
            }
            if (!choleskyDecomposition.isSPD()) {
                throw new XMLParseException("samplingPrecision must be a positive definite matrix.");
            }
            String string = traitsAndMissingIndices.traitName;
            boolean bl = xMLObject.getAttribute(RepeatedMeasuresTraitDataModel.SCALE_BY_TIP_HEIGHT, false);
            if (!bl) {
                return new RepeatedMeasuresTraitDataModel(string, compoundParameter, blArray, true, matrixParameterInterface.getColumnDimension(), matrixParameterInterface);
            }
            return new TreeScaledRepeatedMeasuresTraitDataModel(string, compoundParameter, blArray, true, matrixParameterInterface.getColumnDimension(), matrixParameterInterface);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return RepeatedMeasuresTraitDataModel.class;
        }

        @Override
        public String getParserName() {
            return RepeatedMeasuresTraitDataModel.REPEATED_MEASURES_MODEL;
        }
    };
    private static final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("samplingPrecision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(MutableTreeModel.class), AttributeRule.newStringRule("traitName"), new ElementRule("traitParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("missingIndicator", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), AttributeRule.newBooleanRule("scaleByTipHeight", true)};

    public RepeatedMeasuresTraitDataModel(String string, CompoundParameter compoundParameter, boolean[] blArray, boolean bl, int n, MatrixParameterInterface matrixParameterInterface) {
        super(string, compoundParameter, blArray, bl, n, n == 1 ? PrecisionType.SCALAR : PrecisionType.FULL);
        this.traitName = string;
        this.samplingPrecisionParameter = matrixParameterInterface;
        this.addVariable(matrixParameterInterface);
        this.calculatePrecisionInfo();
        this.samplingVariance = null;
        this.samplingPrecisionParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, matrixParameterInterface.getDimension()));
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        int n2;
        assert (this.numTraits == 1);
        assert (this.samplingPrecision.rows() == this.dimTrait && this.samplingPrecision.columns() == this.dimTrait);
        this.recomputeVariance();
        if (bl) {
            throw new RuntimeException("Incompatible with this model.");
        }
        double[] dArray = super.getTipPartial(n, bl);
        if (this.precisionType == PrecisionType.SCALAR) {
            return dArray;
        }
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(dArray, this.dimTrait + this.dimTrait * this.dimTrait, this.dimTrait, this.dimTrait);
        if (this.diagonalOnly) {
            for (n2 = 0; n2 < this.dimTrait; ++n2) {
                denseMatrix64F.set(n2, n2, denseMatrix64F.get(n2, n2) + 1.0 / this.samplingPrecision.component(n2, n2));
            }
        } else {
            for (n2 = 0; n2 < this.dimTrait; ++n2) {
                for (int i = 0; i < this.dimTrait; ++i) {
                    denseMatrix64F.set(n2, i, denseMatrix64F.get(n2, i) + this.samplingVariance.component(n2, i));
                }
            }
        }
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, false);
        MissingOps.unwrap(denseMatrix64F2, dArray, this.dimTrait);
        MissingOps.unwrap(denseMatrix64F, dArray, this.dimTrait + this.dimTrait * this.dimTrait);
        return dArray;
    }

    @Override
    public boolean[] getTraitMissingIndicators() {
        if (this.getDataMissingIndicators() == null) {
            return null;
        }
        if (this.missingTraitIndicators == null) {
            this.missingTraitIndicators = new boolean[this.getParameter().getDimension()];
            Arrays.fill(this.missingTraitIndicators, true);
        }
        return this.missingTraitIndicators;
    }

    private void recomputeVariance() {
        this.checkVariableChanged();
        if (!this.varianceKnown) {
            this.samplingVariance = this.samplingPrecision.inverse();
            this.varianceKnown = true;
        }
    }

    public Matrix getSamplingVariance() {
        this.recomputeVariance();
        return this.samplingVariance;
    }

    public String getTraitName() {
        return this.traitName;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.samplingPrecisionParameter) {
            this.variableChanged = true;
            this.varianceKnown = false;
            this.fireModelChanged();
        }
    }

    private void calculatePrecisionInfo() {
        this.samplingPrecision = new Matrix(this.samplingPrecisionParameter.getParameterAsMatrix());
    }

    private void checkVariableChanged() {
        if (this.variableChanged) {
            this.calculatePrecisionInfo();
            this.variableChanged = false;
            this.varianceKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedSamplingPrecision = this.samplingPrecision.clone();
        this.storedSamplingVariance = this.samplingVariance.clone();
        this.storedVarianceKnown = this.varianceKnown;
        this.storedVariableChanged = this.variableChanged;
    }

    @Override
    protected void restoreState() {
        Matrix matrix = this.samplingPrecision;
        this.samplingPrecision = this.storedSamplingPrecision;
        this.storedSamplingPrecision = matrix;
        matrix = this.samplingVariance;
        this.samplingVariance = this.storedSamplingVariance;
        this.storedSamplingVariance = matrix;
        this.varianceKnown = this.storedVarianceKnown;
        this.variableChanged = this.storedVariableChanged;
    }

    @Override
    public ContinuousExtensionDelegate getExtensionDelegate(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, TreeTrait treeTrait, Tree tree) {
        this.checkVariableChanged();
        return new ContinuousExtensionDelegate.MultivariateNormalExtensionDelegate(continuousDataLikelihoodDelegate, treeTrait, this, tree);
    }

    @Override
    public boolean diagonalVariance() {
        return false;
    }

    @Override
    public DenseMatrix64F getExtensionVariance() {
        this.recomputeVariance();
        double[] dArray = this.samplingVariance.toArrayComponents();
        return DenseMatrix64F.wrap(this.dimTrait, this.dimTrait, dArray);
    }

    @Override
    public DenseMatrix64F getExtensionVariance(NodeRef nodeRef) {
        return this.getExtensionVariance();
    }

    public void getMeanTipVariances(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        CommonOps.scale(1.0, denseMatrix64F, denseMatrix64F2);
    }

    @Override
    public MatrixParameterInterface getExtensionPrecision() {
        this.checkVariableChanged();
        return this.samplingPrecisionParameter;
    }

    @Override
    public double[] transformTreeTraits(double[] dArray) {
        return dArray;
    }

    @Override
    public int getDataDimension() {
        return this.dimTrait;
    }

    @Override
    public boolean suppliesWishartStatistics() {
        return false;
    }

    @Override
    public void chainRuleWrtVariance(double[] dArray, NodeRef nodeRef) {
    }
}

