/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Statistic;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.RobustEigenDecomposition;
import dr.xml.Reportable;
import org.ejml.data.DenseMatrix64F;

public abstract class AbstractVarianceProportionStatistic
extends Statistic.Abstract
implements Reportable {
    protected final Tree tree;
    protected final Boolean isTreeRandom;
    protected final RepeatedMeasuresTraitDataModel dataModel;
    protected final TreeDataLikelihood treeLikelihood;
    private DenseMatrix64F diffusionProportion;
    protected DenseMatrix64F diffusionComponent;
    protected DenseMatrix64F samplingComponent;
    private final MatrixRatios ratio;
    protected final int dimTrait;

    public AbstractVarianceProportionStatistic(Tree tree, TreeDataLikelihood treeDataLikelihood, RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel, MatrixRatios matrixRatios) {
        this.tree = tree;
        this.treeLikelihood = treeDataLikelihood;
        this.dataModel = repeatedMeasuresTraitDataModel;
        this.dimTrait = repeatedMeasuresTraitDataModel.getTraitDimension();
        this.diffusionProportion = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        this.diffusionComponent = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        this.samplingComponent = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        this.ratio = matrixRatios;
        this.isTreeRandom = tree instanceof AbstractModel && ((AbstractModel)((Object)tree)).isVariable();
    }

    @Override
    public String getReport() {
        Matrix matrix = new Matrix(this.dimTrait, this.dimTrait);
        for (int i = 0; i < this.dimTrait; ++i) {
            int n = this.dimTrait * i;
            for (int j = 0; j < this.dimTrait; ++j) {
                matrix.set(i, j, this.getStatisticValue(n + j));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Variance proportion statistic: " + this.ratio.name());
        stringBuilder.append("\n");
        stringBuilder.append("stat value = ");
        stringBuilder.append(matrix);
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }

    private void updateDiffsionProportion() throws IllegalDimension {
        this.updateVarianceComponents();
        this.ratio.setMatrixRatio(this.diffusionComponent, this.samplingComponent, this.diffusionProportion);
    }

    protected abstract void updateVarianceComponents();

    private static Matrix getMatrixSqrt(Matrix matrix, Boolean bl) {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(matrix.toComponents());
        RobustEigenDecomposition robustEigenDecomposition = new RobustEigenDecomposition(denseDoubleMatrix2D, 100);
        DoubleMatrix1D doubleMatrix1D = robustEigenDecomposition.getRealEigenvalues();
        int n = doubleMatrix1D.size();
        for (int i = 0; i < n; ++i) {
            double d = Math.sqrt(doubleMatrix1D.get(i));
            if (bl.booleanValue()) {
                d = 1.0 / d;
            }
            doubleMatrix1D.set(i, d);
        }
        DoubleMatrix2D doubleMatrix2D = robustEigenDecomposition.getV();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                doubleMatrix2D.set(i, j, doubleMatrix2D.get(i, j) * doubleMatrix1D.get(j));
            }
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(n, n);
        doubleMatrix2D.zMult(robustEigenDecomposition.getV(), denseDoubleMatrix2D2, 1.0, 0.0, false, true);
        return new Matrix(denseDoubleMatrix2D2.toArray());
    }

    @Override
    public int getDimension() {
        return this.dimTrait * this.dimTrait;
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n / this.dimTrait;
        int n3 = n - n2 * this.dimTrait;
        return this.getStatisticName() + (n2 + 1) + (n3 + 1);
    }

    @Override
    public double getStatisticValue(int n) {
        boolean bl = this.needToUpdate(n);
        if (bl) {
            try {
                this.updateDiffsionProportion();
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
        }
        int n2 = n / this.dimTrait;
        int n3 = n - n2 * this.dimTrait;
        return this.diffusionProportion.get(n2, n3);
    }

    protected abstract boolean needToUpdate(int var1);

    public static enum MatrixRatios {
        ELEMENT_WISE{

            @Override
            void setMatrixRatio(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
                int n = denseMatrix64F3.numRows;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        double d = Math.abs(denseMatrix64F.get(i, j));
                        double d2 = Math.abs(denseMatrix64F2.get(i, j));
                        if (d == 0.0 && d2 == 0.0) {
                            denseMatrix64F3.set(i, j, 0.0);
                            continue;
                        }
                        denseMatrix64F3.set(i, j, d / (d + d2));
                    }
                }
            }
        }
        ,
        SYMMETRIC_DIVISION{

            @Override
            void setMatrixRatio(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) throws IllegalDimension {
                throw new RuntimeException((Object)((Object)SYMMETRIC_DIVISION) + " not yet implemented.");
            }
        }
        ,
        CO_HERITABILITY{

            @Override
            void setMatrixRatio(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
                for (int i = 0; i < denseMatrix64F3.numRows; ++i) {
                    double d = denseMatrix64F.get(i, i) / (denseMatrix64F.get(i, i) + denseMatrix64F2.get(i, i));
                    denseMatrix64F3.set(i, i, d);
                    for (int j = i + 1; j < denseMatrix64F3.numRows; ++j) {
                        double d2 = denseMatrix64F.get(i, j);
                        double d3 = denseMatrix64F.get(i, i) + denseMatrix64F2.get(i, i);
                        double d4 = denseMatrix64F.get(j, j) + denseMatrix64F2.get(j, j);
                        d = d2 / Math.sqrt(d3 * d4);
                        denseMatrix64F3.set(i, j, d);
                        denseMatrix64F3.set(j, i, d);
                    }
                }
            }
        };


        abstract void setMatrixRatio(DenseMatrix64F var1, DenseMatrix64F var2, DenseMatrix64F var3) throws IllegalDimension;
    }
}

