/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.AbstractTraceList;
import dr.inference.trace.NumberUtils;
import dr.inference.trace.Trace;
import dr.inference.trace.TraceException;
import dr.inference.trace.TraceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LogFileTraces
extends AbstractTraceList {
    public static final int MIN_SAMPLE = 5;
    private final int MAX_UNIQUE_VALUE = 200;
    protected final File file;
    protected final String name;
    private final List<Trace> traces = new ArrayList<Trace>();
    private long burnIn = -1L;
    private long firstState = -1L;
    private long secondState = -1L;
    private long lastState = -1L;
    private long stepSize = -1L;

    public LogFileTraces(String string, File file) {
        this.name = string;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getMaxState() {
        return this.lastState;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public int getStateCount() {
        return (int)((this.lastState - this.firstState) / this.stepSize - this.getBurnIn() / this.stepSize + 1L);
    }

    @Override
    public int getBurninStateCount() {
        return (int)(this.getBurnIn() / this.stepSize);
    }

    @Override
    public long getStepSize() {
        return this.stepSize;
    }

    @Override
    public long getBurnIn() {
        return this.burnIn;
    }

    @Override
    public int getTraceCount() {
        return this.traces.size();
    }

    @Override
    public int getTraceIndex(String string) {
        for (int i = 0; i < this.traces.size(); ++i) {
            Trace trace = this.getTrace(i);
            if (!string.equals(trace.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getTraceName(int n) {
        return this.getTrace(n).getName();
    }

    @Override
    public Trace getTrace(int n) {
        return this.traces.get(n);
    }

    public void setBurnIn(long l) {
        this.burnIn = l;
        for (Trace trace : this.traces) {
            trace.setTraceStatistics(null);
        }
    }

    public double getStateValue(int n, int n2) {
        return this.getTrace(n).getValue(n2 + (int)(this.getBurnIn() / this.stepSize));
    }

    public void getStateValues(int n, double[] dArray, int n2) {
        int n3 = n + (int)(this.getBurnIn() / this.stepSize);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getTrace(i + n2).getValue(n3);
        }
    }

    @Override
    public List<Double> getValues(int n, int n2, int n3) {
        List<Double> list = null;
        try {
            Trace trace = this.getTrace(n);
            list = trace.getValues(n2, n3, this.filtered);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("getValues error: trace index = " + n);
        }
        return list;
    }

    @Override
    public List<Double> getValues(int n) {
        return this.getValues(n, this.getBurninStateCount(), this.getTrace(n).getValueCount());
    }

    @Override
    public List<Double> getBurninValues(int n) {
        return this.getValues(n, 0, this.getBurninStateCount());
    }

    public void loadTraces() throws TraceException, IOException {
        this.loadTraces(this.file);
    }

    public void loadTraces(File file) throws TraceException, IOException {
        FileReader fileReader = new FileReader(file);
        this.loadTraces(fileReader);
        ((Reader)fileReader).close();
    }

    public void loadTraces(InputStream inputStream) throws TraceException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.loadTraces(inputStreamReader);
        ((Reader)inputStreamReader).close();
    }

    private void loadTraces(Reader reader) throws TraceException, IOException {
        int n;
        TrimLineReader trimLineReader = new TrimLineReader(reader);
        StringTokenizer stringTokenizer = trimLineReader.tokenizeLine();
        if (stringTokenizer == null) {
            throw new TraceException("Trace file is empty.");
        }
        while (!stringTokenizer.hasMoreTokens()) {
            stringTokenizer = trimLineReader.tokenizeLine();
        }
        String string = stringTokenizer.nextToken();
        while (string.startsWith("[") || string.startsWith("#")) {
            stringTokenizer = trimLineReader.tokenizeLine();
            while (!stringTokenizer.hasMoreTokens()) {
                stringTokenizer = trimLineReader.tokenizeLine();
            }
            string = stringTokenizer.nextToken();
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
            this.addTrace(stringArray[n]);
        }
        n = this.getTraceCount();
        long l = 0L;
        String string2 = trimLineReader.readLine();
        stringTokenizer = trimLineReader.getStringTokenizer(string2);
        String string3 = string2;
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            long l2 = 0L;
            try {
                try {
                    l2 = (long)Double.parseDouble(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TraceException("Unable to parse state number in column 1 (Line " + trimLineReader.getLineNumber() + ")");
                }
                if (l < 1L && l2 == 1L) {
                    l2 = 0L;
                }
                if (!this.addState(l2, ++l)) {
                    throw new TraceException("State " + l2 + " is not consistent with previous spacing (Line " + trimLineReader.getLineNumber() + ")");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TraceException("State " + l2 + ":Expected real value in column " + trimLineReader.getLineNumber());
            }
            for (int i = 0; i < n; ++i) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new TraceException("State " + l2 + ": missing values at line " + trimLineReader.getLineNumber());
                }
                String string5 = stringTokenizer.nextToken();
                this.addParsedValue(i, string5);
            }
            string3 = string2;
            string2 = trimLineReader.readLine();
            stringTokenizer = trimLineReader.getStringTokenizer(string2);
        }
        if (l == 0L) {
            throw new TraceException("Incorrect file format, no sample is found !");
        }
        this.burnIn = this.lastState / 10L;
        if (this.lastState < 0L) {
            this.lastState = this.firstState;
        }
        if (this.stepSize < 0L && this.lastState > 0L) {
            this.stepSize = this.lastState;
        }
        this.validateTraceType(string3);
        this.validateUniqueValues();
    }

    private void validateUniqueValues() throws TraceException {
        for (int i = 0; i < this.getTraceCount(); ++i) {
            int n;
            Trace trace = this.getTrace(i);
            if (!trace.getTraceType().isInteger() || (n = trace.getUniqueValueCount()) <= 200) continue;
            System.out.println("Too many unique values (>200) found in trace " + trace.getName() + " at " + i);
            this.changeTraceType(i, TraceType.REAL);
        }
    }

    private void validateTraceType(String string) throws TraceException {
        String[] stringArray = string.split("\\t");
        for (int i = 1; i < stringArray.length; ++i) {
            int n = i - 1;
            Trace trace = this.getTrace(n);
            if (!trace.getTraceType().isInteger() || !NumberUtils.hasDecimalPoint(stringArray[i])) continue;
            this.changeTraceType(n, TraceType.REAL);
        }
    }

    private void addParsedValue(int n, String string) throws TraceException {
        Trace trace = this.getTrace(n);
        TraceType traceType = trace.getTraceType();
        if (traceType != TraceType.CATEGORICAL) {
            if (NumberUtils.isNumber(string)) {
                if (traceType != TraceType.REAL && NumberUtils.hasDecimalPoint(string)) {
                    traceType = TraceType.REAL;
                    this.changeTraceType(n, traceType);
                }
            } else {
                traceType = TraceType.CATEGORICAL;
                trace = this.changeTraceType(n, traceType);
            }
        }
        if (traceType == TraceType.REAL) {
            trace.add(Double.parseDouble(string));
        } else if (traceType == TraceType.INTEGER) {
            trace.add(Double.parseDouble(string));
        } else if (traceType == TraceType.CATEGORICAL) {
            trace.add(string);
        } else {
            throw new IllegalArgumentException("Unsupported TraceType");
        }
    }

    private void addTrace(String string) {
        this.traces.add(new Trace(string, TraceType.INTEGER));
    }

    private void addTrace(String string, TraceType traceType) {
        this.traces.add(new Trace(string, traceType));
    }

    public Trace changeTraceType(int n, TraceType traceType) throws TraceException {
        if (n >= this.getTraceCount() || n < 0) {
            throw new TraceException("Invalid trace id : " + n + ", which should 0 < and >= " + this.getTraceCount());
        }
        Trace trace = this.getTrace(n);
        TraceType traceType2 = trace.getTraceType();
        if (traceType2 != traceType) {
            int n2;
            if (traceType2.isCategorical()) {
                throw new TraceException("A categorical type cannot be changed to anything else.");
            }
            Trace trace2 = new Trace(trace.getName(), traceType);
            if (traceType.isDiscrete() && (n2 = trace.getUniqueValueCount()) > 200) {
                throw new TraceException("Type change is failed, because too many unique values (>200) are found !");
            }
            if (traceType.isCategorical()) {
                try {
                    for (n2 = 0; n2 < trace.getValueCount(); ++n2) {
                        trace2.add(Double.toString(trace.getValue(n2)));
                    }
                }
                catch (Exception exception) {
                    throw new TraceException("Type change is failed, when parsing " + (Object)((Object)traceType2) + " to " + (Object)((Object)traceType) + " in trace " + trace.getName());
                }
                if (trace2.getValueCount() != trace.getValueCount()) {
                    throw new TraceException("Type change is failed, because values size is different after copy !");
                }
                this.traces.set(n, trace2);
            } else {
                trace.setTraceType(traceType);
            }
            return trace2;
        }
        return trace;
    }

    private boolean addState(long l, long l2) {
        if (this.firstState < 0L) {
            this.firstState = l;
        } else if (this.secondState < 0L) {
            this.secondState = l;
        } else if (this.stepSize < 0L) {
            this.stepSize = l - this.secondState;
        } else {
            long l3 = l - this.lastState;
            if (l3 != this.stepSize) {
                System.out.println("step: " + l3 + " != " + this.stepSize);
                return false;
            }
        }
        this.lastState = l;
        return true;
    }

    public static class TrimLineReader
    extends BufferedReader {
        private int lineNumber = 0;

        public TrimLineReader(Reader reader) {
            super(reader);
        }

        @Override
        public String readLine() throws IOException {
            ++this.lineNumber;
            String string = super.readLine();
            if (string != null) {
                return string.trim();
            }
            return null;
        }

        public StringTokenizer tokenizeLine() throws IOException {
            String string = this.readLine();
            return this.getStringTokenizer(string);
        }

        public StringTokenizer getStringTokenizer(String string) {
            if (string == null) {
                return null;
            }
            return new StringTokenizer(string, "\t");
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

