/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.Filter;
import dr.inference.trace.TraceCorrelation;
import dr.inference.trace.TraceType;
import dr.stats.FrequencyCounter;
import dr.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Trace {
    private static final int MAX_UNIQUE_VALUES = 100;
    private TraceType traceType = TraceType.REAL;
    private List<Double> values = new ArrayList<Double>();
    private String name;
    private boolean isConstant = true;
    private double constantValue = Double.NaN;
    private List<String> categoryValueList = new ArrayList<String>();
    private Map<Integer, String> categoryLabelMap = null;
    private OrderType orderType = OrderType.DEFAULT;
    private List<Integer> categoryOrder = null;
    private Set<Integer> uniqueValues = new TreeSet<Integer>();
    private TraceCorrelation traceStatistics;
    protected Filter filter = null;

    public Trace(String string) {
        this.name = string;
    }

    public Trace(String string, TraceType traceType) {
        this.name = string;
        this.setTraceType(traceType);
    }

    public void add(Double d) {
        if (this.uniqueValues.size() < 100) {
            this.uniqueValues.add(d.intValue());
        }
        if (this.isConstant && d != this.constantValue) {
            this.isConstant = false;
        } else if (Double.isNaN(this.constantValue)) {
            this.constantValue = d;
        }
        this.values.add(d);
    }

    public void add(Double[] doubleArray) {
        for (Double d : doubleArray) {
            this.add(d);
        }
    }

    public void add(Integer n) {
        if (this.uniqueValues.size() < 100) {
            this.uniqueValues.add(n);
        }
        double d = n.doubleValue();
        if (this.isConstant && d != this.constantValue) {
            this.isConstant = false;
        } else if (Double.isNaN(this.constantValue)) {
            this.constantValue = d;
        }
        this.values.add(d);
    }

    public void add(String string) {
        int n = this.categoryValueList.indexOf(string);
        if (n < 0) {
            this.categoryValueList.add(string);
            n = this.categoryValueList.size() - 1;
            if (this.categoryLabelMap == null) {
                this.categoryLabelMap = new HashMap<Integer, String>();
            }
            this.categoryLabelMap.put(n, string);
        }
        this.add(n);
    }

    public void add(String[] stringArray) {
        for (String string : stringArray) {
            this.add(string);
        }
    }

    public FrequencyCounter<Integer> getFrequencyCounter() {
        assert (this.traceType.isDiscrete());
        return this.getTraceStatistics().getFrequencyCounter();
    }

    public List<Integer> getCategoryOrder() {
        return this.categoryOrder;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        switch (orderType) {
            case DEFAULT: {
                this.categoryOrder = new ArrayList<Integer>();
                for (int i = 0; i < this.getUniqueValueCount(); ++i) {
                    this.categoryOrder.add(i);
                }
                break;
            }
            case NATURAL: {
                this.categoryOrder = this.getNaturalOrder();
                break;
            }
            case FREQUENCY: {
                this.categoryOrder = this.getFrequencyCounter().getOrderByFrequency();
            }
        }
    }

    private List<Integer> getNaturalOrder() {
        ArrayList<Integer> arrayList;
        if (this.traceType == TraceType.CATEGORICAL) {
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            for (Integer object : this.getFrequencyCounter().getUniqueValues()) {
                if (this.categoryLabelMap != null) {
                    arrayList2.add(new Pair<Comparable, Integer>((Comparable)((Object)this.categoryLabelMap.get(object)), n));
                } else {
                    arrayList2.add(new Pair<Integer, Integer>(object, n));
                }
                ++n;
            }
            Collections.sort(arrayList2, new Comparator<Pair<Comparable, Integer>>(){

                @Override
                public int compare(Pair<Comparable, Integer> pair, Pair<Comparable, Integer> pair2) {
                    return ((Comparable)pair.fst).compareTo(pair2.fst);
                }
            });
            arrayList = new ArrayList();
            for (Pair pair : arrayList2) {
                arrayList.add((Integer)pair.snd);
            }
        } else {
            arrayList = new ArrayList<Integer>(this.getFrequencyCounter().getUniqueValues());
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public int getUniqueValueCount() {
        return this.uniqueValues.size();
    }

    public double getValue(int n) {
        return this.values.get(n);
    }

    public int getCategory(int n) {
        return this.values.get(n).intValue();
    }

    public String getCategoryLabel(int n) {
        return this.categoryLabelMap.get(this.getCategory(n));
    }

    public Map<Integer, String> getCategoryLabelMap() {
        return this.categoryLabelMap;
    }

    public double[] getRange() {
        if (this.getValueCount() < 1) {
            throw new IllegalArgumentException("Cannot find values in trace " + this.getName());
        }
        if (this.getTraceType().isNumber()) {
            Double d = Double.MAX_VALUE;
            Double d2 = Double.MIN_VALUE;
            for (Double d3 : this.values) {
                if (d3 < d) {
                    d = d3;
                    continue;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            return new double[]{d, d2};
        }
        throw new UnsupportedOperationException("cannot call getRange for categorical data");
    }

    public List<Double> getValues(int n, int n2) {
        return this.getValues(n, n2, null);
    }

    public List<Double> getValues(int n, int n2, boolean[] blArray) {
        if (n2 > this.getValueCount() || n > n2) {
            throw new RuntimeException("Invalid index : fromIndex = " + n + "; toIndex = " + n2 + "; List size = " + this.getValueCount() + "; in Trace " + this.name);
        }
        if (blArray == null || blArray.length < 1) {
            return this.values.subList(n, n2);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = n; i < n2; ++i) {
            if (blArray[i]) continue;
            arrayList.add(this.values.get(i));
        }
        if (arrayList.size() < 1) {
            throw new RuntimeException("There is no value left after all filters are applied !");
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public TraceCorrelation getTraceStatistics() {
        return this.traceStatistics;
    }

    public void setTraceStatistics(TraceCorrelation traceCorrelation) {
        this.traceStatistics = traceCorrelation;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public static double[] toArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i);
        }
        return dArray;
    }

    public static enum OrderType {
        DEFAULT,
        NATURAL,
        FREQUENCY;

    }
}

