/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.evolution.util.MutableTaxonList;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Taxa
implements MutableTaxonList,
Identifiable,
Comparable<Taxa> {
    private final ArrayList<MutableTaxonListListener> mutableTaxonListListeners = new ArrayList();
    ArrayList<Taxon> taxa = new ArrayList();
    private String id = null;

    public Taxa() {
    }

    public Taxa(String string) {
        this.id = string;
    }

    public Taxa(TaxonList taxonList) {
        this.addTaxa(taxonList);
    }

    public Taxa(Collection<Taxon> collection) {
        this.addTaxa(collection);
    }

    @Override
    public int addTaxon(Taxon taxon) {
        int n = this.getTaxonIndex(taxon);
        if (n == -1) {
            this.taxa.add(taxon);
            this.fireTaxonAdded(taxon);
            n = this.taxa.size() - 1;
        }
        return n;
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        boolean bl = this.taxa.remove(taxon);
        if (bl) {
            this.fireTaxonRemoved(taxon);
        }
        return bl;
    }

    public void addTaxa(TaxonList taxonList) {
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            this.addTaxon(taxonList.getTaxon(i));
        }
    }

    public void addTaxa(Collection<Taxon> collection) {
        for (Taxon taxon : collection) {
            this.addTaxon(taxon);
        }
    }

    public void removeTaxa(TaxonList taxonList) {
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            this.removeTaxon(taxonList.getTaxon(i));
        }
    }

    public void removeTaxa(Collection<Taxon> collection) {
        for (Taxon taxon : collection) {
            this.removeTaxon(taxon);
        }
    }

    public void removeAllTaxa() {
        this.taxa.clear();
        this.fireTaxonRemoved(null);
    }

    @Override
    public int getTaxonCount() {
        return this.taxa.size();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.taxa.get(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.taxa.get(n).getId();
    }

    @Override
    public void setTaxonId(int n, String string) {
        this.taxa.get(n).setId(string);
        this.fireTaxaChanged();
    }

    @Override
    public int getTaxonIndex(String string) {
        for (int i = 0; i < this.taxa.size(); ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        for (int i = 0; i < this.taxa.size(); ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        return new ArrayList<Taxon>(this.taxa);
    }

    public boolean contains(Taxon taxon) {
        return this.taxa.contains(taxon);
    }

    public boolean containsAny(TaxonList taxonList) {
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            if (!this.taxa.contains(taxon)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Collection<Taxon> collection) {
        for (Taxon taxon : collection) {
            if (!collection.contains(taxon)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TaxonList taxonList) {
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            if (this.taxa.contains(taxon)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<Taxon> collection) {
        for (Taxon taxon : collection) {
            if (collection.contains(taxon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public int compareTo(Taxa taxa) {
        return this.getId().compareTo(taxa.getId());
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.taxa.iterator();
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        Taxon taxon = this.getTaxon(n);
        taxon.setAttribute(string, object);
        this.fireTaxaChanged();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        return taxon.getAttribute(string);
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        this.mutableTaxonListListeners.add(mutableTaxonListListener);
    }

    private void fireTaxonAdded(Taxon taxon) {
        for (MutableTaxonListListener mutableTaxonListListener : this.mutableTaxonListListeners) {
            mutableTaxonListListener.taxonAdded(this, taxon);
        }
    }

    private void fireTaxonRemoved(Taxon taxon) {
        for (MutableTaxonListListener mutableTaxonListListener : this.mutableTaxonListListeners) {
            mutableTaxonListListener.taxonRemoved(this, taxon);
        }
    }

    private void fireTaxaChanged() {
        for (MutableTaxonListListener mutableTaxonListListener : this.mutableTaxonListListeners) {
            mutableTaxonListListener.taxaChanged(this);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TaxonList)) {
            return false;
        }
        return TaxonList.Utils.areTaxaIdentical(this, (TaxonList)object);
    }
}

