/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.LUDecomposition;
import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexColtEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.GeneralSubstitutionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Vector;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComplexSubstitutionModel
extends GeneralSubstitutionModel
implements Likelihood,
Citable {
    private boolean isUsed = false;
    private final double[] probability = new double[this.stateCount * this.stateCount];
    private boolean doNormalization = true;

    public ComplexSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter) {
        super(string, dataType, frequencyModel, parameter, -1);
    }

    @Override
    protected void setupDimensionNames(int n) {
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.ratesParameter.getParameterName();
        for (n3 = 0; n3 < this.dataType.getStateCount(); ++n3) {
            for (n2 = n3 + 1; n2 < this.dataType.getStateCount(); ++n2) {
                arrayList.add(this.getDimensionString(n3, n2, string));
            }
        }
        for (n3 = 0; n3 < this.dataType.getStateCount(); ++n3) {
            for (n2 = n3 + 1; n2 < this.dataType.getStateCount(); ++n2) {
                arrayList.add(this.getDimensionString(n2, n3, string));
            }
        }
        String[] stringArray = new String[]{};
        this.ratesParameter.setDimensionNames(arrayList.toArray(stringArray));
    }

    @Override
    protected EigenSystem getDefaultEigenSystem(int n) {
        return new ComplexColtEigenSystem(n);
    }

    protected void computeStationaryDistribution(double[] dArray) {
        int n;
        double[][] dArray2 = this.getRelativeRateMatrixWithoutPi();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.stateCount + 1, this.stateCount);
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                denseDoubleMatrix2D.set(i, n, dArray2[n][i]);
            }
        }
        for (n = 0; n < this.stateCount; ++n) {
            denseDoubleMatrix2D.set(this.stateCount, n, 1.0);
        }
        LUDecomposition lUDecomposition = new LUDecomposition(denseDoubleMatrix2D);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(this.stateCount + 1, 1);
        denseDoubleMatrix2D2.set(this.stateCount, 0, 1.0);
        DoubleMatrix2D doubleMatrix2D = lUDecomposition.solve(denseDoubleMatrix2D2);
        for (int i = 0; i < this.stateCount; ++i) {
            dArray[i] = doubleMatrix2D.get(i, 0);
        }
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        this.getTransitionProbabilities(d, dArray, this.getEigenDecomposition());
    }

    protected void getTransitionProbabilities(double d, double[] dArray, EigenDecomposition eigenDecomposition) {
        int n;
        double d2;
        int n2;
        if (eigenDecomposition == null) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = eigenDecomposition.getEigenVectors();
        double[] dArray3 = eigenDecomposition.getEigenValues();
        double[] dArray4 = new double[this.stateCount];
        System.arraycopy(dArray3, this.stateCount, dArray4, 0, this.stateCount);
        double[] dArray5 = eigenDecomposition.getInverseEigenVectors();
        double[][] dArray6 = new double[this.stateCount][this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            if (dArray4[n2] == 0.0) {
                d2 = Math.exp(d * dArray3[n2]);
                for (n = 0; n < this.stateCount; ++n) {
                    dArray6[n2][n] = dArray5[n2 * this.stateCount + n] * d2;
                }
                continue;
            }
            n = n2 + 1;
            double d3 = dArray4[n2];
            double d4 = Math.exp(d * dArray3[n2]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (int i = 0; i < this.stateCount; ++i) {
                dArray6[n2][i] = d5 * dArray5[n2 * this.stateCount + i] + d6 * dArray5[n * this.stateCount + i];
                dArray6[n][i] = d5 * dArray5[n * this.stateCount + i] - d6 * dArray5[n2 * this.stateCount + i];
            }
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                d2 = 0.0;
                for (int j = 0; j < this.stateCount; ++j) {
                    d2 += dArray2[n * this.stateCount + j] * dArray6[j][i];
                }
                dArray[n2] = Math.abs(d2);
                ++n2;
            }
        }
    }

    @Override
    protected int getRateCount(int n) {
        return (n - 1) * n;
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.ratesParameter.getParameterValue(i);
        }
    }

    private double[][] getRelativeRateMatrixWithoutPi() {
        this.setupRelativeRates(this.relativeRates);
        double[][] dArray = new double[this.stateCount][this.stateCount];
        double[] dArray2 = new double[this.stateCount];
        Arrays.fill(dArray2, 1.0);
        this.setupQMatrix(this.relativeRates, dArray2, dArray);
        this.makeValid(dArray, this.stateCount);
        return dArray;
    }

    @Override
    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            for (n = n2 + 1; n < this.stateCount; ++n) {
                int n4 = n3++;
                d = dArray[n4];
                if (d < 0.0) {
                    d = 0.0;
                }
                dArray3[n2][n] = d * dArray2[n];
            }
        }
        for (n = 0; n < this.stateCount; ++n) {
            for (n2 = n + 1; n2 < this.stateCount; ++n2) {
                int n5 = n3++;
                d = dArray[n5];
                if (d < 0.0) {
                    d = 0.0;
                }
                dArray3[n2][n] = d * dArray2[n];
            }
        }
    }

    @Override
    public boolean canReturnComplexDiagonalization() {
        return true;
    }

    @Override
    protected double getNormalizationValue(double[][] dArray, double[] dArray2) {
        double d = 1.0;
        if (this.doNormalization) {
            d = super.getNormalizationValue(dArray, dArray2);
        }
        return d;
    }

    @Override
    public double getLogLikelihood() {
        if (BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this)) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean evaluateEarly() {
        return true;
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    @Override
    public void setNormalization(boolean bl) {
        this.doNormalization = bl;
    }

    public boolean getNormalization() {
        return this.doNormalization;
    }

    @Override
    public void makeDirty() {
    }

    public void printLastProbabilityMatrix() {
        this.getLogLikelihood();
        System.err.println(this.probability == null ? "Null probability vector" : "Not null probability vector");
        if (this.probability == null) {
            boolean bl = BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this);
            System.err.println("BSSVS valid = " + bl);
        }
        System.err.println(new Vector(this.probability));
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Collections.singletonList(this));
    }

    @Override
    public boolean isUsed() {
        return super.isUsed() && this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId()), new NormalizationColumn(this.getId())};
    }

    void setDoNormalization(boolean bl) {
        this.doNormalization = bl;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Complex-diagonalizable, irreversible substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.EDWARDS_2011_ANCIENT);
    }

    public Model getRateProvider() {
        throw new RuntimeException("Method implement only in specific subclasses");
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ComplexSubstitutionModel.this.getLogLikelihood();
        }
    }

    protected class NormalizationColumn
    extends NumberColumn {
        public NormalizationColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ComplexSubstitutionModel.this.getEigenDecomposition().getNormalization();
        }
    }
}

