/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.ModelListener;
import dr.inference.model.Variable;
import dr.util.Identifiable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public interface Model
extends Identifiable,
Serializable {
    public static final Set<Model> FULL_MODEL_SET = new LinkedHashSet<Model>();
    public static final Set<Model> CONNECTED_MODEL_SET = new LinkedHashSet<Model>();

    public void addModelListener(ModelListener var1);

    public void removeModelListener(ModelListener var1);

    public void storeModelState();

    public void restoreModelState();

    public void acceptModelState();

    public boolean isValidState();

    public int getModelCount();

    public Model getModel(int var1);

    public int getVariableCount();

    public Variable getVariable(int var1);

    public String getModelName();

    public boolean isUsed();

    public static class ListenerHelper
    implements Serializable {
        private ArrayList<ModelListener> listeners = null;
        private ArrayList<ModelListener> restoreListeners = null;

        public void fireModelChanged(Model model) {
            this.fireModelChanged(model, model, -1);
        }

        public void fireModelChanged(Model model, Object object) {
            this.fireModelChanged(model, object, -1);
        }

        public void fireModelChanged(Model model, Object object, int n) {
            if (this.listeners != null) {
                for (ModelListener modelListener : this.listeners) {
                    modelListener.modelChangedEvent(model, object, n);
                }
            }
        }

        public void addModelListener(ModelListener modelListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(modelListener);
        }

        public void removeModelListener(ModelListener modelListener) {
            if (this.listeners != null) {
                this.listeners.remove(modelListener);
            }
        }

        public void addModelRestoreListener(ModelListener modelListener) {
            if (this.restoreListeners == null) {
                this.restoreListeners = new ArrayList();
            }
            this.restoreListeners.add(modelListener);
        }

        public void fireModelRestored(Model model) {
            if (this.restoreListeners != null) {
                for (ModelListener modelListener : this.restoreListeners) {
                    modelListener.modelRestored(model);
                }
            }
        }

        public int getListenerCount() {
            return this.listeners != null ? this.listeners.size() : 0;
        }
    }
}

