/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GibbsIndependentJointNormalGammaOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "GibbsIndependentJointNormalGammaOperator";
    public static final String MEAN = "mean";
    public static final String PREC = "precision";
    public static final String SHAPE = "shape";
    public static final String SCALE = "scale";
    private Variable<Double> mean = null;
    private Variable<Double> precision = null;
    private NormalDistributionModel model = null;
    private GammaDistribution gamma = null;
    private boolean updateAllIndependently = true;
    private static final boolean TRY_COLT = true;
    private static final boolean DEBUG = false;
    private static RandomEngine randomEngine;
    private static Normal coltNormal;
    public static XMLObjectParser PARSER;

    public GibbsIndependentJointNormalGammaOperator(Variable variable, Variable variable2, NormalDistributionModel normalDistributionModel, GammaDistribution gammaDistribution) {
        this(variable, variable2, normalDistributionModel, gammaDistribution, 1.0);
    }

    public GibbsIndependentJointNormalGammaOperator(Variable variable, Variable variable2, NormalDistributionModel normalDistributionModel, GammaDistribution gammaDistribution, double d) {
        this(variable, variable2, normalDistributionModel, gammaDistribution, d, true);
    }

    public GibbsIndependentJointNormalGammaOperator(Variable variable, Variable variable2, NormalDistributionModel normalDistributionModel, GammaDistribution gammaDistribution, double d, boolean bl) {
        this.mean = variable;
        this.precision = variable2;
        this.model = normalDistributionModel;
        this.gamma = gammaDistribution;
        this.updateAllIndependently = bl;
        this.setWeight(d);
        randomEngine = new MersenneTwister(MathUtils.nextInt());
        coltNormal = new Normal(0.0, 1.0, randomEngine);
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "GibbsIndependentJointNormalGamma(" + this.mean.getVariableName() + "," + this.precision.getVariableName() + ")";
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        Bounds<Double> bounds = this.mean.getBounds();
        Bounds<Double> bounds2 = this.precision.getBounds();
        int n = this.mean.getSize();
        if (this.updateAllIndependently) {
            for (int i = 0; i < n; ++i) {
                double d = this.gamma.nextGamma();
                while (d == 0.0) {
                    d = this.gamma.nextGamma();
                }
                if (d < bounds2.getLowerLimit(i) || d > bounds2.getUpperLimit(i)) {
                    throw new RuntimeException("proposed value from gamma distribution outside boundaries");
                }
                this.precision.setValue(i, d);
                d = coltNormal.nextDouble(this.model.getMean().getValue(i), 1.0 / Math.sqrt(this.model.getPrecision().getValue(i)));
                if (d < bounds.getLowerLimit(i) || d > bounds.getUpperLimit(i)) {
                    throw new RuntimeException("proposed value from normal distribution outside boundaries");
                }
                this.mean.setValue(i, d);
            }
        }
        return 0.0;
    }

    static {
        PARSER = new AbstractXMLObjectParser(){
            private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("shape"), AttributeRule.newDoubleRule("scale"), new ElementRule(NormalDistributionModel.class), new ElementRule("mean", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("precision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

            @Override
            public String getParserName() {
                return GibbsIndependentJointNormalGammaOperator.OPERATOR_NAME;
            }

            @Override
            public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
                double d = xMLObject.getDoubleAttribute("weight");
                double d2 = xMLObject.getDoubleAttribute(GibbsIndependentJointNormalGammaOperator.SHAPE);
                double d3 = xMLObject.getDoubleAttribute(GibbsIndependentJointNormalGammaOperator.SCALE);
                NormalDistributionModel normalDistributionModel = (NormalDistributionModel)xMLObject.getChild(NormalDistributionModel.class);
                XMLObject xMLObject2 = xMLObject.getChild(GibbsIndependentJointNormalGammaOperator.MEAN);
                Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
                xMLObject2 = xMLObject.getChild(GibbsIndependentJointNormalGammaOperator.PREC);
                Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
                return new GibbsIndependentJointNormalGammaOperator(parameter, parameter2, normalDistributionModel, new GammaDistribution(d2, d3), d);
            }

            @Override
            public XMLSyntaxRule[] getSyntaxRules() {
                return this.rules;
            }

            @Override
            public String getParserDescription() {
                return "This element returns an independence sampler, disguised as a Gibbs operator, from provided normal and gamma distributions.";
            }

            @Override
            public Class getReturnType() {
                return MCMCOperator.class;
            }
        };
    }
}

