/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.MCMCOperator;
import java.io.Serializable;
import java.util.List;

public interface OperatorSchedule
extends Serializable {
    public static final String SHOW_OPERATORS = "show_operators";
    public static final OptimizationTransform DEFAULT_TRANSFORM = OptimizationTransform.LOG;
    public static final int POWERB = 1;
    public static final double POWERC = 0.5556;

    public int getNextOperatorIndex();

    public int getOperatorCount();

    public MCMCOperator getOperator(int var1);

    public void addOperator(MCMCOperator var1);

    public void addOperators(List<MCMCOperator> var1);

    public void operatorsHasBeenUpdated();

    public OptimizationTransform getOptimizationTransform();

    public long getMinimumAcceptAndRejectCount();

    public static enum OptimizationTransform {
        LOG("log"){

            @Override
            public double transform(double d) {
                return Math.log(d);
            }
        }
        ,
        SQRT("sqrt"){

            @Override
            public double transform(double d) {
                return Math.sqrt(d);
            }
        }
        ,
        LINEAR("linear"){

            @Override
            public double transform(double d) {
                return d;
            }
        }
        ,
        POWER("power"){

            @Override
            public double transform(double d) {
                return Math.pow(d / 1.0, 0.5556);
            }
        };

        private final String name;

        private OptimizationTransform(String string2) {
            this.name = string2;
        }

        public abstract double transform(double var1);

        public String toString() {
            return this.name;
        }
    }
}

