/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.math.MathUtils;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.treelikelihood.AbstractLikelihoodCore;
import dr.oldevomodel.treelikelihood.TreeLikelihood;
import java.util.logging.Logger;

@Deprecated
public class AncestralStateTreeLikelihood
extends TreeLikelihood
implements TreeTraitProvider {
    public static final String STATES_KEY = "states";
    protected TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    private DataType dataType;
    private int[][] reconstructedStates;
    private int[][] storedReconstructedStates;
    private String tag;
    private boolean areStatesRedrawn = false;
    private boolean storedAreStatesRedrawn = false;
    private boolean useMAP = false;
    private boolean returnMarginalLogLikelihood = true;
    private double jointLogLikelihood;
    private double storedJointLogLikelihood;

    public AncestralStateTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, boolean bl, boolean bl2, final DataType dataType, final String string, boolean bl3, boolean bl4, boolean bl5) {
        super(patternList, treeModel, siteModel, branchRateModel, null, bl, false, bl2, false, bl3);
        this.dataType = dataType;
        this.tag = string;
        this.reconstructedStates = new int[treeModel.getNodeCount()][this.patternCount];
        this.storedReconstructedStates = new int[treeModel.getNodeCount()][this.patternCount];
        this.useMAP = bl4;
        this.returnMarginalLogLikelihood = bl5;
        this.treeTraits.addTrait(STATES_KEY, new TreeTrait.IA(){

            @Override
            public String getTraitName() {
                return string;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public int[] getTrait(Tree tree, NodeRef nodeRef) {
                return AncestralStateTreeLikelihood.this.getStatesForNode(tree, nodeRef);
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                return AncestralStateTreeLikelihood.formattedState(AncestralStateTreeLikelihood.this.getStatesForNode(tree, nodeRef), dataType);
            }
        });
        if (bl) {
            Logger.getLogger("dr.evomodel.treelikelihood").info("Ancestral reconstruction using ambiguities is currently not support without BEAGLE");
            System.exit(-1);
        }
    }

    public AncestralStateTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, boolean bl, boolean bl2, DataType dataType, String string, boolean bl3) {
        this(patternList, treeModel, siteModel, branchRateModel, bl, bl2, dataType, string, bl3, false, true);
    }

    @Override
    public void storeState() {
        super.storeState();
        for (int i = 0; i < this.reconstructedStates.length; ++i) {
            System.arraycopy(this.reconstructedStates[i], 0, this.storedReconstructedStates[i], 0, this.reconstructedStates[i].length);
        }
        this.storedAreStatesRedrawn = this.areStatesRedrawn;
        this.storedJointLogLikelihood = this.jointLogLikelihood;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        int[][] nArray = this.reconstructedStates;
        this.reconstructedStates = this.storedReconstructedStates;
        this.storedReconstructedStates = nArray;
        this.areStatesRedrawn = this.storedAreStatesRedrawn;
        this.jointLogLikelihood = this.storedJointLogLikelihood;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int[] getStatesForNode(Tree tree, NodeRef nodeRef) {
        if (tree != this.treeModel) {
            throw new RuntimeException("Can only reconstruct states on treeModel given to constructor");
        }
        if (!this.likelihoodKnown) {
            this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        if (!this.areStatesRedrawn) {
            this.redrawAncestralStates();
        }
        return this.reconstructedStates[nodeRef.getNumber()];
    }

    public void redrawAncestralStates() {
        this.jointLogLikelihood = 0.0;
        this.traverseSample(this.treeModel, this.treeModel.getRoot(), null);
        this.areStatesRedrawn = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        super.handleModelChangedEvent(model, object, n);
        this.fireModelChanged(model);
    }

    @Override
    protected double calculateLogLikelihood() {
        this.areStatesRedrawn = false;
        double d = super.calculateLogLikelihood();
        if (this.returnMarginalLogLikelihood) {
            return d;
        }
        this.redrawAncestralStates();
        return this.jointLogLikelihood;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    private static String formattedState(int[] nArray, DataType dataType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        if (dataType instanceof GeneralDataType) {
            boolean bl = true;
            for (int n : nArray) {
                if (!bl) {
                    stringBuffer.append(" ");
                } else {
                    bl = false;
                }
                stringBuffer.append(dataType.getCode(n));
            }
        } else {
            for (int n : nArray) {
                stringBuffer.append(dataType.getChar(n));
            }
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private int drawChoice(double[] dArray) {
        if (this.useMAP) {
            double d = dArray[0];
            int n = 0;
            for (int i = 1; i < dArray.length; ++i) {
                if (!(dArray[i] > d)) continue;
                d = dArray[i];
                n = i;
            }
            return n;
        }
        return MathUtils.randomChoicePDF(dArray);
    }

    public void traverseSample(TreeModel treeModel, NodeRef nodeRef, int[] nArray) {
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        double[] dArray = new double[this.stateCount];
        int[] nArray2 = new int[this.patternCount];
        if (!treeModel.isExternal(nodeRef)) {
            int n2;
            Object object;
            if (nodeRef2 == null) {
                object = this.getRootPartials();
                for (n2 = 0; n2 < this.patternCount; ++n2) {
                    System.arraycopy(object, n2 * this.stateCount, dArray, 0, this.stateCount);
                    double[] dArray2 = this.frequencyModel.getFrequencies();
                    for (int i = 0; i < this.stateCount; ++i) {
                        int n3 = i;
                        dArray[n3] = dArray[n3] * dArray2[i];
                    }
                    try {
                        nArray2[n2] = this.drawChoice(dArray);
                    }
                    catch (Error error) {
                        System.err.println(error.toString());
                        System.err.println("Please report error to Marc");
                        nArray2[n2] = 0;
                    }
                    this.reconstructedStates[n][n2] = nArray2[n2];
                    this.jointLogLikelihood += Math.log(dArray2[nArray2[n2]]);
                }
            } else {
                object = new double[this.stateCount * this.patternCount];
                if (this.categoryCount > 1) {
                    throw new RuntimeException("Reconstruction not implemented for multiple categories yet.");
                }
                this.likelihoodCore.getPartials(n, (double[])object);
                ((AbstractLikelihoodCore)this.likelihoodCore).getNodeMatrix(n, 0, this.probabilities);
                for (n2 = 0; n2 < this.patternCount; ++n2) {
                    int n4 = nArray[n2] * this.stateCount;
                    int n5 = n2 * this.stateCount;
                    for (int i = 0; i < this.stateCount; ++i) {
                        dArray[i] = object[n5 + i] * this.probabilities[n4 + i];
                    }
                    nArray2[n2] = this.drawChoice(dArray);
                    this.reconstructedStates[n][n2] = nArray2[n2];
                    double d = this.probabilities[n4 + nArray2[n2]];
                    this.jointLogLikelihood += Math.log(d);
                }
            }
            object = treeModel.getChild(nodeRef, 0);
            this.traverseSample(treeModel, (NodeRef)object, nArray2);
            NodeRef nodeRef3 = treeModel.getChild(nodeRef, 1);
            this.traverseSample(treeModel, nodeRef3, nArray2);
        } else {
            ((AbstractLikelihoodCore)this.likelihoodCore).getNodeStates(n, this.reconstructedStates[n]);
            for (int i = 0; i < this.patternCount; ++i) {
                int n6 = this.reconstructedStates[n][i];
                int n7 = nArray[i] * this.stateCount;
                ((AbstractLikelihoodCore)this.likelihoodCore).getNodeMatrix(n, 0, this.probabilities);
                if (this.dataType.isAmbiguousState(n6)) {
                    System.arraycopy(this.probabilities, n7, dArray, 0, this.stateCount);
                    this.reconstructedStates[n][i] = this.drawChoice(dArray);
                }
                double d = this.probabilities[n7 + this.reconstructedStates[n][i]];
                this.jointLogLikelihood += Math.log(d);
            }
        }
    }
}

