% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergmAPL.R
\name{ergmAPL}
\alias{ergmAPL}
\title{Adjustment of ERGM pseudolikelihood}
\usage{
ergmAPL(
  formula,
  aux.iters = NULL,
  n.aux.draws = NULL,
  aux.thin = NULL,
  ladder = NULL,
  estimate = c("MLE", "CD"),
  seed = 1,
  ...
)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{aux.iters}{count; number of auxiliary iterations used for drawing the first network from the ERGM likelihood. See \code{\link[ergm]{control.simulate.formula}}.}

\item{n.aux.draws}{count; Number of auxiliary networks drawn from the ERGM likelihood. See \code{\link[ergm]{control.simulate.formula}}.}

\item{aux.thin}{count; Number of auxiliary iterations between network draws after the first network is drawn. See \code{\link[ergm]{control.simulate.formula}}.}

\item{ladder}{count; Length of temperature ladder (>=3).}

\item{estimate}{If "MLE" (the default), then an approximate maximum likelihood estimator is returned. If "CD" , the Monte-Carlo contrastive divergence estimate is returned. See \code{\link[ergm]{ergm}}.}

\item{seed}{integer; seed for the random number generator. See \code{set.seed}.}

\item{...}{Additional arguments, to be passed to the ergm function. See \code{\link[ergm]{ergm}}.}
}
\description{
Function to estimate the transformation parameters for
adjusting the pseudolikelihood function.
}
\references{
Bouranis, L., Friel, N., & Maire, F. (2018). Bayesian model selection for exponential 
random graph models via adjusted pseudolikelihoods. 
Journal of Computational and Graphical Statistics, 27(3), 516-528. \url{https://arxiv.org/abs/1706.06344}
}
