% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdAdd_hdf5_matrix}
\alias{bdAdd_hdf5_matrix}
\title{Write matrix to existing hdf5 file}
\usage{
bdAdd_hdf5_matrix(
  object,
  filename,
  group,
  dataset,
  transp = NULL,
  force = FALSE
)
}
\arguments{
\item{object}{numerical data matrix}

\item{filename, }{character array indicating the name of the file to create}

\item{group, }{character array indicating folder or group name to put the matrix in hdf5 file}

\item{dataset, }{character array indicating the dataset name that contains the matix data}

\item{transp, }{boolean if true, data is manipulated in transposed form}

\item{force, }{optional boolean if true and file exists, removes old file and creates a new file with de dataset data.}
}
\value{
none
}
\description{
Creates a hdf5 file with numerical data matrix,
}
\examples{

matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)
matB <- matrix(c(15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,5,3,4,5,2,6,2,3,4,
                   42, 23, 23, 423,1,2), nrow = 3, byrow = TRUE)
                   
bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", matA, "INPUT", "matA")
bdAdd_hdf5_matrix(matB, "BasicMatVect.hdf5", "INPUT", "matB")

# Remove file (used as example)
  if (file.exists("BasicMatVect.hdf5")) {
    # Delete file if it exist
    file.remove("BasicMatVect.hdf5")
  }

}
