% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/701-readFASTA.R
\name{readFASTA}
\alias{readFASTA}
\title{Read Protein/DNA Sequences in FASTA Format}
\usage{
readFASTA(file = system.file("protseq/P00750.fasta", package =
  "BioMedR"), legacy.mode = TRUE, seqonly = FALSE)
}
\arguments{
\item{file}{The name of the file which the sequences in fasta format are 
to be read from. If it does not contain an absolute or 
relative path, the file name is relative to the current 
working directory, \code{\link{getwd}}. 
The default here is to read the \code{P00750.fasta} file which 
is present in the \code{protseq} directory of the BioMedR package.}

\item{legacy.mode}{If set to \code{TRUE}, lines starting with a semicolon ';'
are ignored. Default value is \code{TRUE}.}

\item{seqonly}{If set to \code{TRUE}, only sequences as returned without 
attempt to modify them or to get their names and 
annotations (execution time is divided approximately
by a factor 3). Default value is \code{FALSE}.}
}
\value{
The result character vector
}
\description{
Read Protein/DNA Sequences in FASTA Format
}
\details{
This function reads protein sequences in FASTA format.
}
\note{
Note that any different sets of instances (chunklets),
      e.g. {1, 3, 7} and {4, 6}, might belong to the 
      same class and might belong to different classes.
}
\examples{
P00750 = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))

}
\references{
Pearson, W.R. and Lipman, D.J. (1988) 
Improved tools for biological sequence comparison. 
\emph{Proceedings of the National Academy of Sciences 
of the United States of America}, \bold{85}: 2444-2448
}
\seealso{
See \code{\link{readPDB}} for reading protein sequences 
in PDB format.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{BioMedR}
\keyword{FASTA}
\keyword{readFASTA}
