% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/videoToFrames.r
\name{videoToFrames}
\alias{videoToFrames}
\title{Extract Frames from a Video and Save as Images}
\usage{
videoToFrames(videoPath, outputDir)
}
\arguments{
\item{videoPath}{Path to the video file.}

\item{outputDir}{Path to the directory where the extracted images will be saved.}
}
\value{
A list of file paths to the generated images.
}
\description{
This function takes a video file, processes it, and saves the frames as individual images in the specified directory. The images are saved in PNG format by default, and at a rate of 1 frame per second.
}
\examples{
\donttest{
# Not run:
videoPath <- system.file('extdata/video.mp4', package='BioTrajectory')
outputDir <- system.file('extdata/frames/', package='BioTrajectory')
images <- videoToFrames(videoPath, outputDir)
print(images)  # Displays the paths to the generated images
}
}
