% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boundary.R
\name{plot_boundary}
\alias{plot_boundary}
\title{Map the boundary elements of two raster layers}
\usage{
plot_boundary(x, y, color = NA, trait_names = NA)
}
\arguments{
\item{x}{A SpatRaster object with boundary elements.}

\item{y}{A SpatRaster object with boundary elements.}

\item{color}{Optional. A character vector of up to three colors (x boundary, y boundary, and overlapping elements).}

\item{trait_names}{Optional. A character vector with up to two elements (legend name for x and legend name for y).}
}
\value{
A ggplot2 object.
}
\description{
This is a wrapper function for ggplot2 that will produce a map of boundary
elements for two traits and show where boundary elements intersect.
}
\examples{
data(T.cristatus)
T.cristatus <- terra::rast(T.cristatus_matrix, crs = T.cristatus_crs)
terra::ext(T.cristatus) <- T.cristatus_ext

data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

Tcrist_boundaries <- categorical_boundary(T.cristatus)
grassland_boundaries <- define_boundary(grassland, 0.1)

plot_boundary(Tcrist_boundaries, grassland_boundaries)

}
\author{
Amy Luo
}
