% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population2sample.test.R
\name{population2sample.test}
\alias{population2sample.test}
\title{Identify differences of partial correlations between two populations}
\usage{
population2sample.test(popEst1, popEst2, alpha = 0.05, c0 = 0.1, MBT = 3000)
}
\arguments{
\item{popEst1}{A \code{popEst} class object.}

\item{popEst2}{A \code{popEst} class object.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{c0}{threshold of the exceedance rate of the false discovery proportion (FDP),
default value is \code{0.1}.
The choice of \code{c0} depends on the empirical problem. A smaller value of \code{c0} will
reduce false positives, but it may also cost more false negatives.}

\item{MBT}{times of multiplier bootstrap, default value is \code{3000}.}
}
\value{
A \eqn{p*p} matrix with values 0 or 1.
If the j-th row and k-th column of the matrix is 1,
then the partial correlation coefficients between
the j-th variable and the k-th variable in two populations
are identified to be unequal.
}
\description{
Identify differences of partial correlations between two populations
in two groups of time series data
by controlling the exceedance rate of the false discovery proportion (FDP)
at \eqn{\alpha=0.05}, considering time dependence.
Input two groups of data \eqn{Z_1} and \eqn{Z_2}, each contains values of p interested
variables of individuals
(the number of individuals in two groups can be different) over n periods.
\cr
\cr
}
\examples{
## Quick example for the two-sample case inference
data(popsimA)
data(popsimB)
pc1 = population.est(popsimA)
pc2 = population.est(popsimB)
Res = population2sample.test(pc1, pc2)          # conducting hypothesis test

}
\references{
Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
