% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelection.R, R/summaryBranchGLMVS.R
\name{plot.BranchGLMVS}
\alias{plot.BranchGLMVS}
\alias{plot.summary.BranchGLMVS}
\title{Plot Method for summary.BranchGLMVS and BranchGLMVS objects}
\usage{
\method{plot}{BranchGLMVS}(
  x,
  ptype = "both",
  marnames = 7,
  addLines = TRUE,
  type = "b",
  horiz = FALSE,
  cex.names = 1,
  cex.lab = 1,
  cex.axis = 1,
  cex.legend = 1,
  cols = c("deepskyblue", "indianred", "forestgreen"),
  ...
)

\method{plot}{summary.BranchGLMVS}(
  x,
  ptype = "both",
  marnames = 7,
  addLines = TRUE,
  type = "b",
  horiz = FALSE,
  cex.names = 1,
  cex.lab = 1,
  cex.axis = 1,
  cex.legend = 1,
  cols = c("deepskyblue", "indianred", "forestgreen"),
  ...
)
}
\arguments{
\item{x}{a \code{summary.BranchGLMVS} or \code{BranchGLMVS} object.}

\item{ptype}{the type of plot to produce, look at details for more explanation.}

\item{marnames}{value used to determine how large to make margin of axis with variable 
names, this is only for the "variables" plot. If variable names are cut-off, 
consider increasing this from the default value of 7.}

\item{addLines}{logical value to indicate whether or not to add black lines to 
separate the models for the "variables" plot. This is typically useful for smaller 
amounts of models, but can be annoying if there are many models.}

\item{type}{what type of plot to draw for the "metrics" plot, see more details at \link{plot.default}.}

\item{horiz}{whether models should be displayed horizontally or vertically in the "variables" plot.}

\item{cex.names}{how big to make variable names in the "variables" plot.}

\item{cex.lab}{how big to make axis labels.}

\item{cex.axis}{how big to make axis annotation.}

\item{cex.legend}{how big to make legend labels.}

\item{cols}{the colors used to create the "variables" plot. Should be a character 
vector of length 3, the first color will be used for included variables, 
the second color will be used for excluded variables, and the third color will 
be used for kept variables.}

\item{...}{further arguments passed to the generic plot and image methods.}
}
\value{
This only produces plots, nothing is returned.
}
\description{
Plot Method for summary.BranchGLMVS and BranchGLMVS objects
}
\details{
The different values for ptype are as follows
\itemize{
 \item "metrics" for a plot that displays the metric values ordered by rank
 \item "variables" for a plot that displays which variables are in each of the top models
 \item "both" for both plots
}

If there are so many models that the "variables" plot appears to be 
entirely black, then set addLines to FALSE.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", bestmodels = 10, 
showprogress = FALSE)
VS

## Getting summary of the process
Summ <- summary(VS)
Summ

## Plotting the BIC of best models
plot(Summ, type = "b", ptype = "metrics")

## Plotting the BIC of the best models 
plot(Summ, ptype = "variables")

### Alternative colors
plot(Summ, ptype = "variables", 
cols = c("yellowgreen", "purple1", "grey50"))

### Smaller text size for names
plot(Summ, ptype = "variables", cex.names = 0.75)

}
