% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_file.R
\name{convert_file}
\alias{convert_file}
\title{convert file}
\usage{
convert_file(url, input_file, output, output_path, token, wait = 60,
  download = TRUE)
}
\arguments{
\item{url}{The URL to the Brown Dog Server to use}

\item{input_file}{The input file, either local file with path, or file url}

\item{output}{The output format extension}

\item{output_path}{The path for the created output file. May contain different filename. note the path ends with '/'}

\item{token}{Brown Dog access token}

\item{wait}{The amount of time to wait for the DAP service to respond. Default is 60}

\item{download}{The flag to download the result file. Default is true}
}
\value{
The output filename
}
\description{
Convert a file using Brown Dog Conversion service
}
\examples{
\dontrun{
key <- get_key("https://bd-api-dev.ncsa.illinois.edu", "your email", "password")
token <- get_token("https://bd-api-dev.ncsa.illinois.edu", key)
convert_file("https://bd-api-dev.ncsa.illinois.edu", 
"http://browndog.ncsa.illinois.edu/examples/gi/Dongying_sample.csv", "xlsx", "/", 
token)
}
}
