% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simBuyseTest.R
\name{Simulation function}
\alias{Simulation function}
\alias{simBuyseTest}
\title{Simulation of data for the BuyseTest}
\usage{
simBuyseTest(
  n.T,
  n.C = NULL,
  argsBin = list(),
  argsCont = list(),
  argsTTE = list(),
  n.strata = NULL,
  names.strata = NULL,
  format = "data.table",
  latent = FALSE
)
}
\arguments{
\item{n.T}{[integer, >0] number of patients in the treatment arm}

\item{n.C}{[integer, >0] number of patients in the control arm}

\item{argsBin}{[list] arguments to be passed to \code{simBuyseTest_bin}. They specify the distribution parameters of the binary endpoints.}

\item{argsCont}{[list] arguments to be passed to \code{simBuyseTest_continuous}. They specify the distribution parameters of the continuous endpoints.}

\item{argsTTE}{[list]  arguments to be passed to \code{simBuyseTest_TTE}. They specify the distribution parameters of the time to event endpoints.}

\item{n.strata}{[integer, >0] number of strata. \code{NULL} indicates no strata.}

\item{names.strata}{[character vector] name of the strata variables. Must have same length as \code{n.strata}.}

\item{format}{[character] the format of the output. Can be \code{"data.table"}, \code{"data.frame"} or \code{"matrix"}.}

\item{latent}{[logical] If \code{TRUE} also export the latent variables (e.g. censoring times or event times).}
}
\description{
Simulate binary, continuous or time to event data, possibly with strata.
Outcomes are simulated independently of each other and independently of the strata variable.
}
\details{
This function is built upon the \code{lvm} and \code{sim} functions from the lava package.

Arguments in the list \code{argsBin}:
\itemize{
    \item\code{p.T} probability of event of each endpoint (binary endpoint, treatment group). \cr 
    \item\code{p.C} same as \code{p.T} but for the control group. \cr
    \item\code{name} names of the binary variables. \cr
}

Arguments in the list \code{argsCont}:
    \itemize{
    \item\code{mu.T} expected value of each endpoint (continuous endpoint, treatment group). \cr 
    \item\code{mu.C} same as \code{mu.C} but for the control group. \cr
    \item\code{sigma.T} standard deviation of the values of each endpoint (continuous endpoint, treatment group). \cr 
    \item\code{sigma.C} same as \code{sigma.T} but for the control group. \cr
    \item\code{name} names of the continuous variables.
    }

Arguments in the list \code{argsTTE}:
    \itemize{
    \item\code{CR} should competing risks be simulated? \cr 
    \item\code{rates.T} hazard corresponding to each endpoint (time to event endpoint, treatment group). \cr 
    \item\code{rates.C} same as \code{rates.T} but for the control group. \cr
    \item\code{rates.CR} same as \code{rates.T} but for the competing event (same in both groups). \cr
    \item\code{rates.Censoring.T} Censoring same as \code{rates.T} but for the censoring. \cr
    \item\code{rates.Censoring.C} Censoring same as \code{rates.C} but for the censoring. \cr
    \item\code{name} names of the time to event variables. \cr
    \item\code{nameCensoring} names of the event type indicators. \cr
    }
}
\examples{
library(data.table)

n <- 1e2

#### default option ####
simBuyseTest(n)

## with a strata variable having 5 levels
simBuyseTest(n, n.strata = 5)
## with a strata variable named grade
simBuyseTest(n, n.strata = 5, names.strata = "grade")
## several strata variables
simBuyseTest(1e3, n.strata = c(2,4), names.strata = c("Gender","AgeCategory"))

#### only binary endpoints ####
args <- list(p.T = c(3:5/10))
simBuyseTest(n, argsBin = args, argsCont = NULL, argsTTE = NULL)

#### only continuous endpoints ####
args <- list(mu.T = c(3:5/10), sigma.T = rep(1,3))
simBuyseTest(n, argsBin = NULL, argsCont = args, argsTTE = NULL)

#### only TTE endpoints ####
args <- list(rates.T = c(3:5/10), rates.Censoring.T = rep(1,3))
simBuyseTest(n, argsBin = NULL, argsCont = NULL, argsTTE = args)
        

}
\author{
Brice Ozenne
}
\keyword{function}
\keyword{simulations}
