% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-confint.R
\docType{methods}
\name{S4BuyseTest-confint}
\alias{S4BuyseTest-confint}
\alias{confint,S4BuyseTest-method}
\title{Confidence Intervals for Model Parameters}
\usage{
\S4method{confint}{S4BuyseTest}(
  object,
  statistic = NULL,
  null = NULL,
  conf.level = NULL,
  alternative = NULL,
  method.ci.resampling = NULL,
  order.Hprojection = NULL,
  transformation = NULL,
  cluster = NULL
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"favorable"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
\code{"unfavorable"} displays the proportion in favor of the control.
Default value read from \code{BuyseTest.options()}.}

\item{null}{[numeric] right hand side of the null hypothesis (used for the computation of the p-value).}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{method.ci.resampling}{[character] the method used to compute the confidence intervals and p-values when using bootstrap or permutation (\code{"percentile"}, \code{"gaussian"}, \code{"student"}).
See the details section.}

\item{order.Hprojection}{[integer, 1-2] order of the H-decomposition used to compute the variance.}

\item{transformation}{[logical]  should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{cluster}{[numeric vector] Group of observations for which the iid assumption holds .}
}
\value{
A matrix containing a column for the estimated statistic (over all strata),
the lower bound and upper bound of the confidence intervals, and the associated p-values.
When using resampling methods:
\itemize{
\item an attribute \code{n.resampling} specified how many samples have been used to compute the confidence intervals and the p-values.
\item an attribute \code{method.ci.resampling} method used to compute the confidence intervals and p-values. 
}
}
\description{
Computes confidence intervals for net benefit statistic or the win ratio statistic.
}
\details{
\bold{statistic}: when considering a single endpoint and denoting
\eqn{Y} the endpoint in the treatment group,
\eqn{X} the endpoint in the control group,
and \eqn{\tau} the threshold of clinical relevance,
the net benefit is \eqn{P[Y \ge X + \tau] - P[X \ge Y + \tau]},
the win ratio is \eqn{\frac{P[Y \ge X + \tau]}{P[X \ge Y + \tau]}},
the proportion in favor of treatment is \eqn{P[Y \ge X + \tau]},
the proportion in favor of control is \eqn{P[X \ge Y + \tau]}.

\bold{method.ci.resampling}: when using bootstrap/permutation, p-values and confidence intervals are computing as follow: \itemize{
\item \code{percentile} (bootstrap): compute the confidence interval using the quantiles of the bootstrap estimates.
Compute the p-value by finding the confidence level at which a bound of the confidence interval equals the null hypothesis.

\item \code{percentile} (permutation): apply the selected transformation to the estimate and permutation estimates.
Compute the confidence interval by (i) shfiting the estimate by the quantiles of the centered permutation estimates and (ii) back-transforming .
Compute the p-value as the relative frequency at which the estimate are less extreme than the permutation estimates.

\item \code{gaussian} (bootstrap and permutation): apply the selected transformation to the estimate and bootstrap/permutation estimates.
Estimate the variance of the estimator using the empirical variance of the transformed boostrap/permutation estimates.
Compute confidence intervals and p-values under the normality assumption and back-transform the confidence intervals.

\item \code{student} (bootstrap): apply the selected transformation to the estimate, its standard error, the bootstrap estimates, and their standard error.
Compute the studentized bootstrap estimates by dividing the centered bootstrap estimates by their standard error. 
Compute the confidence interval based on the standard error of the estimate and the quantiles of the studentized bootstrap estimates, and back-transform.
Compute the p-value by finding the confidence level at which a bound of the confidence interval equals the null hypothesis.

\item \code{student} (permutation): apply the selected transformation to the estimate, its standard error, the permutation estimates, and their standard error.
Compute the studentized permutation estimates by dividing the centered permutation estimates by their standard error.
Compute the confidence interval based on the standard error of the estimate and the quantiles of the studentized permutation estimates, and back-transform.
Compute the p-value as the relative frequency at which the studentized estimate are less extreme than the permutation studentized estimates.

}

\bold{WARNING}: when using a permutation test, the uncertainty associated with the estimator is computed under the null hypothesis.
Thus the confidence interval may not be valid if the null hypothesis is false. \cr
}
\references{
On the GPC procedure: Marc Buyse (2010). \bold{Generalized pairwise comparisons of prioritized endpoints in the two-sample problem}. \emph{Statistics in Medicine} 29:3245-3257 \cr
On the win ratio: D. Wang, S. Pocock (2016). \bold{A win ratio approach to comparing continuous non-normal outcomes in clinical trials}. \emph{Pharmaceutical Statistics} 15:238-245 \cr
On the Mann-Whitney parameter: Fay, Michael P. et al (2018). \bold{Causal estimands and confidence intervals asscoaited with Wilcoxon-Mann-Whitney tests in randomized experiments}. \emph{Statistics in Medicine} 37:2923-2937 \cr
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{S4BuyseTest-summary}} for a more detailed presentation of the \code{S4BuyseTest} object.
}
\author{
Brice Ozenne
}
\keyword{S4BuyseTest-method}
\keyword{confint}
