% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterForest.R
\name{clusterforest}
\alias{clusterforest}
\title{Clustering the classification trees in a forest based on similarities}
\usage{
clusterforest(similarities, fromclus, toclus)
}
\arguments{
\item{similarities}{A treesimilarities object containing a similarity matrix and the forest object on which the similarities were calculated}

\item{fromclus}{The lowest number of clusters for which the PAM algorithm should be run}

\item{toclus}{The highest number of clusters for which the PAM algorithm should be run}
}
\value{
The function returns an object of class clusterforest, with attributes:
\item{medoids}{the position of the medoid trees in the forest (i.e., which element of the list of partytrees)}
\item{medoidtrees}{the medoid trees}
\item{clusters}{The cluster to which each tree in the forest is assigned}
\item{avgsilwidth}{The average silhouette width for each solution (see Kaufman and Rousseeuw, 2009)}
\item{agreement}{For each solution, the agreement between the predicted class label for each observation based on the forest as a whole, and those based on the
medoids only (see Sies & Van Mechelen,2020)}
\item{withinsim}{Within cluster similarity for each solution (see Sies & Van Mechelen, 2020)}
}
\description{
A function to get insight into a forest of classification trees by clustering the trees in a forest using Partitioning Around Medoids (PAM, Kaufman & Rousseeuw, 2009), based on similarities (see Sies & Van Mechelen, 2020).
}
\details{
This function uses the Partitioning Around Medoids (PAM) algorithm, to cluster trees in a forest,
based on similarities between the trees. The function takes a treesimilarities object as input (see treesimilarities() or as.treesimilarities() to create a treesimilarities object)
and returns a clusterforest object.

The PAM algorithm can be run for solutions with varying number of clusters, depending on the fromclus and toclus arguments.
Results will be returned for each solution.
}
\examples{
require(MASS)
require(rpart)
#Function to draw a bootstrap sample from a dataset
DrawBoots <- function(dataset, i){
set.seed(2394 + i)
Boot <- dataset[sample(1:nrow(dataset), size = nrow(dataset), replace = TRUE),]
return(Boot)
}

#Function to grow a tree using rpart on a dataset
GrowTree <- function(x,y,BootsSample, minsplit = 40, minbucket = 20, maxdepth =3){
 controlrpart <- rpart.control(minsplit = minsplit, minbucket = minbucket, maxdepth = maxdepth,
  maxsurrogate = 0, maxcompete = 0)
 tree <- rpart(as.formula(paste(noquote(paste(y, "~")), noquote(paste(x, collapse="+")))),
 data = BootsSample, control = controlrpart)
 return(tree)
}

#Use functions to draw 15 boostrapsamples and grow a tree on each sample
Boots<- lapply(1:15, function(k) DrawBoots(Pima.tr ,k))
Trees <- lapply(1:15, function (i) GrowTree(x=c("npreg", "glu",  "bp",  "skin",
"bmi", "ped", "age"), y="type", Boots[[i]] ))

#Turn the lists of dataframes and rpart trees to a forest object
myforest<- forest(Pima.tr,Boots,Trees)

#Calculate similarities between trees in forest, based on similarity measure m=1.
Simmatrix1 <- treesimilarities(forest=myforest, m=1)

#cluster forest
ClusterForest <- clusterforest(Simmatrix1, 1, 5)
}
\references{
\cite{Kaufman, L., & Rousseeuw, P. J. (2009). Finding groups in data: an introduction to cluster analysis (Vol. 344). John Wiley & Sons.}

\cite{Sies, A. & Van Mechelen I. (2020). C443: An R-package to see a forest for the trees. Journal of Classification.}
}
