/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class QuantileRegression
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JCheckBox browserResults;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevel;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    private JCheckBox plotCoeffConfBands;
    private JPanel plotOptionsPane;
    private JPanel plotPane;
    private JPanel quantilePane;
    private JScrollPane quantileScrollPane;
    private JTable quantileTable;
    private JCheckBox regScatterPlot;
    private JPanel savePanel;
    private JPanel varPane;

    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuantileRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.quantileTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                QuantileRegression.this.quantileTableTableChanged(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void quantileTableTableChanged(TableModelEvent e) {
        TableModel model;
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (row == 0 && col == 0 && (model = (TableModel)e.getSource()).getValueAt(row, col) == null) {
            model.setValueAt(new Double(0.5), row, col);
        }
        this.refreshValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
        } else {
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.independentList.setListData(nonFactors);
            if (this.dependentComboBox.getItemCount() > 0) {
                this.dependentComboBox.setSelectedIndex(0);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
        }
        this.refreshValidity();
    }

    public void refreshConfLevelValidity() {
        this.confLabel.setEnabled(this.confIntervals.isSelected());
        this.confLevel.setEnabled(this.confIntervals.isSelected());
    }

    public void refreshScatterPlotValidity() {
        this.regScatterPlot.setEnabled(!this.independentList.isSelectionEmpty() && this.independentList.getSelectedIndices().length == 1);
    }

    public void refreshConfBandValidity() {
        TableModel model = this.quantileTable.getModel();
        int numValues = 0;
        int n = model.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (model.getValueAt(i, 0) == null) continue;
            ++numValues;
        }
        boolean enableConfBands = numValues >= 1 && !this.independentList.isSelectionEmpty() && this.independentList.getSelectedIndices().length == 1;
        this.plotCoeffConfBands.setEnabled(enableConfBands);
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshConfLevelValidity();
        this.refreshConfBandValidity();
        this.refreshScatterPlotValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.plotOptionsPane = new JPanel();
        this.regScatterPlot = new JCheckBox();
        this.plotCoeffConfBands = new JCheckBox();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.analysisOptionsPane = new JPanel();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevel = new JSpinner();
        this.quantilePane = new JPanel();
        this.quantileScrollPane = new JScrollPane();
        this.quantileTable = new JTable();
        this.savePanel = new JPanel();
        this.browserResults = new JCheckBox();
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.regScatterPlot.setText("Regression Scatterplot");
        this.plotCoeffConfBands.setText("Coefficient Confidence Bands");
        GroupLayout plotOptionsPaneLayout = new GroupLayout((Container)this.plotOptionsPane);
        this.plotOptionsPane.setLayout((LayoutManager)plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((Component)this.regScatterPlot).add((Component)this.plotCoeffConfBands)).addContainerGap(62, Short.MAX_VALUE)));
        plotOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.regScatterPlot).addPreferredGap(0).add((Component)this.plotCoeffConfBands).addContainerGap(11, Short.MAX_VALUE)));
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout((Container)this.modelEqPane);
        this.modelEqPane.setLayout((LayoutManager)modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -1, 507, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add((GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QuantileRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                QuantileRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(2).add((Component)this.independentLabel).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentScrollPane, -1, 173, Short.MAX_VALUE).add(2, (Component)this.dependentComboBox, 0, 173, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.dependentComboBox, -2, -1, -2).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentLabel).add((Component)this.independentScrollPane, -1, 147, Short.MAX_VALUE)).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                QuantileRegression.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        this.confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout((Container)this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout((LayoutManager)analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((Component)this.confIntervals).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.confLabel).addPreferredGap(0).add((Component)this.confLevel, -2, -1, -2))).addContainerGap(97, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.confIntervals).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.confLabel).add((Component)this.confLevel, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.quantilePane.setBorder(BorderFactory.createTitledBorder("Quantiles"));
        this.quantileScrollPane.setPreferredSize(new Dimension(200, 120));
        this.quantileTable.setModel(new DefaultTableModel(new Object[][]{{new Double(0.5)}, {null}, {null}, {null}, {null}, {null}, {null}, {null}}, new String[]{"Quantiles"}){
            Class[] types;
            {
                this.types = new Class[]{Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.quantileTable.setCellSelectionEnabled(true);
        this.quantileScrollPane.setViewportView(this.quantileTable);
        GroupLayout quantilePaneLayout = new GroupLayout((Container)this.quantilePane);
        this.quantilePane.setLayout((LayoutManager)quantilePaneLayout);
        quantilePaneLayout.setHorizontalGroup((GroupLayout.Group)quantilePaneLayout.createParallelGroup(1).add((GroupLayout.Group)quantilePaneLayout.createSequentialGroup().addContainerGap().add((Component)this.quantileScrollPane, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
        quantilePaneLayout.setVerticalGroup((GroupLayout.Group)quantilePaneLayout.createParallelGroup(1).add((GroupLayout.Group)quantilePaneLayout.createSequentialGroup().addContainerGap().add((Component)this.quantileScrollPane, -1, 173, Short.MAX_VALUE).addContainerGap()));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        this.browserResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QuantileRegression.this.browserResultsActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browserResults).addContainerGap(-1, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addContainerGap(5, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.savePanel, -2, -1, -2).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(2, false).add(1, (Component)this.modelEqPane, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.analysisOptionsPane, -1, -1, Short.MAX_VALUE).add((Component)this.varPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.plotOptionsPane, -1, -1, Short.MAX_VALUE).add((Component)this.quantilePane, -2, -1, -2))))).addContainerGap()));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.modelEqPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.quantilePane, -1, -1, Short.MAX_VALUE).add((Component)this.varPane, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.plotOptionsPane, -1, -1, Short.MAX_VALUE).add((Component)this.analysisOptionsPane, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.savePanel, -2, 47, -2).addContainerGap()));
        this.setTitle("Quantile Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 580) / 2, (screenSize.height - 625) / 2, 580, 625);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.refreshValidity();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshValidity();
    }

    private void browserResultsActionPerformed(ActionEvent evt) {
    }

    private List getColumn(JTable table, int column) {
        if (table != null && column <= table.getColumnCount()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                list.add(table.getValueAt(i, column));
            }
            return list;
        }
        return null;
    }

    protected void submitButtonAction() {
        String cmd = "rq.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", my.formula=" + "'" + this.modelEqTextArea.getText() + "'" + ", my.tau=" + "c(" + RUtils.toString(this.getColumn(this.quantileTable, 0), ",", "'") + ")" + ", iCI=" + String.valueOf(this.confIntervals.isSelected()).toUpperCase() + (this.confIntervals.isSelected() ? ", conf.level=" + (Double)this.confLevel.getValue() : "") + (this.regScatterPlot.isEnabled() ? ", iScatterplot=" + String.valueOf(this.regScatterPlot.isSelected()).toUpperCase() : "") + ", iCIplot=" + String.valueOf(this.plotCoeffConfBands.isSelected()).toUpperCase() + ", dep.var=" + "'" + GUIUtils.getSelectedItem(this.dependentComboBox) + "'" + ", indep.var=" + "c(" + RUtils.toString(this.independentList.getSelectedValues(), ",", "'") + ")" + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('rq.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }
}

