/*
 * ScatterPlot.java
 *
 * Created on September 8, 2005, 10:52 PM
 * Modified on January 29, 2007 (Mark Fitzgerald)
 */
package org.neptuneinc.cadstat.plots;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;

import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

/**
 *
 * @author  Pasha Minallah
 */
public class ScatterPlot extends DataPlotDialog
{
  /** Creates new form ScatterPlot */
  public ScatterPlot()
  {
    super();
  }

  /** Perform custom initialization. */
  @Override
  protected void initCustom()
  {
    this.initComponents();

    this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });
    this.getDatasetPane().refreshDatasetComboBox();

    this.getPlotPane().add(plotPane, BorderLayout.CENTER);
  }

  private void datasetComboBoxActionPerformed(ActionEvent e)
  {
    this.refreshVariableList();
    this.refreshSubmitButtonValidity();
  }

  public void refreshVariableListValidity()
  {
    xComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && xComboBox.getItemCount() > 0);
    yComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && yComboBox.getItemCount() > 0);
  }

  public void refreshVariableList()
  {
    if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0)
    {
      Vector<String> nonFactors = null;

      try
      {
        nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());

        xComboBox.setModel(new DefaultComboBoxModel(nonFactors));
        yComboBox.setModel(new DefaultComboBoxModel(nonFactors));

        if (xComboBox.getItemCount() > 0)
        {
          xComboBox.setSelectedIndex(0);
        }

        if (yComboBox.getItemCount() > 0)
        {
          yComboBox.setSelectedIndex(0);
        }
      }
      catch (REngineException ex)
      {
        Logger.getLogger(ScatterPlot.class.getName()).log(Level.SEVERE, null, ex);
      }
      catch (REXPMismatchException ex)
      {
        Logger.getLogger(ScatterPlot.class.getName()).log(Level.SEVERE, null, ex);
      }
    }
    else
    {
      xComboBox.removeAllItems();
      yComboBox.removeAllItems();
    }

    this.refreshVariableListValidity();
    this.refreshSubmitButtonValidity();
  }

  public void refreshSubmitButtonValidity()
  {
    this.getSubmitButton().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0
      && xComboBox.getItemCount() > 0 && yComboBox.getItemCount() > 0);
  }

  public void refreshConfPredInt()
  {
    confIntCheck.setEnabled(regLineCheck.isSelected() || loessLineCheck.isSelected());
    predIntCheck.setEnabled(regLineCheck.isSelected() || loessLineCheck.isSelected());
    if (!(regLineCheck.isSelected() || loessLineCheck.isSelected()))
    {
      confIntCheck.setSelected(false);
      predIntCheck.setSelected(false);
    }
    confLabel.setEnabled(regLineCheck.isSelected() || loessLineCheck.isSelected());
    confLevelSpinner.setEnabled(regLineCheck.isSelected() || loessLineCheck.isSelected());
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    plotPane = new javax.swing.JPanel();
    topPane = new javax.swing.JPanel();
    varPane = new javax.swing.JPanel();
    xLabel = new javax.swing.JLabel();
    xComboBox = new javax.swing.JComboBox();
    yLabel = new javax.swing.JLabel();
    yComboBox = new javax.swing.JComboBox();
    plotLabelsPane = new javax.swing.JPanel();
    plotTitleLabel = new javax.swing.JLabel();
    plotTitle = new javax.swing.JTextField();
    xAxisLabel = new javax.swing.JLabel();
    xAxis = new javax.swing.JTextField();
    yAxisLabel = new javax.swing.JLabel();
    yAxis = new javax.swing.JTextField();
    plotOptionsPane = new javax.swing.JPanel();
    regLineCheck = new javax.swing.JCheckBox();
    loessLineCheck = new javax.swing.JCheckBox();
    predIntCheck = new javax.swing.JCheckBox();
    confLabel = new javax.swing.JLabel();
    confLevelSpinner = new javax.swing.JSpinner();
    confIntCheck = new javax.swing.JCheckBox();

    topPane.setLayout(new java.awt.GridLayout(1, 2));

    varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

    xLabel.setText("X");

    yLabel.setText("Y");

    javax.swing.GroupLayout varPaneLayout = new javax.swing.GroupLayout(varPane);
    varPane.setLayout(varPaneLayout);
    varPaneLayout.setHorizontalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(varPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(xLabel)
          .addComponent(yLabel))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(yComboBox, 0, 293, Short.MAX_VALUE)
          .addComponent(xComboBox, 0, 293, Short.MAX_VALUE))
        .addContainerGap())
    );
    varPaneLayout.setVerticalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(varPaneLayout.createSequentialGroup()
        .addGroup(varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(xComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(xLabel))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(yComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(yLabel))
        .addContainerGap(50, Short.MAX_VALUE))
    );

    topPane.add(varPane);

    plotLabelsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Labels"));

    plotTitleLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    plotTitleLabel.setLabelFor(plotTitle);
    plotTitleLabel.setText("Plot Title");

    plotTitle.setColumns(12);
    plotTitle.setText("Scatterplot");

    xAxisLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    xAxisLabel.setLabelFor(xAxis);
    xAxisLabel.setText("X-Axis");

    xAxis.setColumns(12);
    xAxis.setText("X");

    yAxisLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    yAxisLabel.setLabelFor(yAxis);
    yAxisLabel.setText("Y-Axis");

    yAxis.setColumns(12);
    yAxis.setText("Y");

    javax.swing.GroupLayout plotLabelsPaneLayout = new javax.swing.GroupLayout(plotLabelsPane);
    plotLabelsPane.setLayout(plotLabelsPaneLayout);
    plotLabelsPaneLayout.setHorizontalGroup(
      plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotLabelsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(xAxisLabel)
          .addComponent(plotTitleLabel)
          .addComponent(yAxisLabel))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(xAxis, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
          .addComponent(plotTitle, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
          .addComponent(yAxis, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE))
        .addContainerGap())
    );
    plotLabelsPaneLayout.setVerticalGroup(
      plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotLabelsPaneLayout.createSequentialGroup()
        .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(plotTitleLabel)
          .addComponent(plotTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(xAxis, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(xAxisLabel))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(plotLabelsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(yAxis, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(yAxisLabel))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    topPane.add(plotLabelsPane);

    plotOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Options"));

    regLineCheck.setText("Linear Regression Line");
    regLineCheck.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        regLineCheckActionPerformed(evt);
      }
    });

    loessLineCheck.setText("Loess Smooth");
    loessLineCheck.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        loessLineCheckActionPerformed(evt);
      }
    });

    predIntCheck.setText("Add Prediction Intervals");
    predIntCheck.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    predIntCheck.setEnabled(false);

    confLabel.setText("Confidence / Prediction Level");
    confLabel.setEnabled(false);

    confLevelSpinner.setModel(new javax.swing.SpinnerNumberModel(0.95d, 0.5d, 0.99d, 0.01d));
    confLevelSpinner.setEnabled(false);

    confIntCheck.setText("Add Confidence Intervals");
    confIntCheck.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    confIntCheck.setEnabled(false);

    javax.swing.GroupLayout plotOptionsPaneLayout = new javax.swing.GroupLayout(plotOptionsPane);
    plotOptionsPane.setLayout(plotOptionsPaneLayout);
    plotOptionsPaneLayout.setHorizontalGroup(
      plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, plotOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(regLineCheck)
          .addComponent(loessLineCheck))
        .addGap(30, 30, 30)
        .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(plotOptionsPaneLayout.createSequentialGroup()
            .addComponent(confIntCheck)
            .addContainerGap())
          .addGroup(plotOptionsPaneLayout.createSequentialGroup()
            .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addGroup(plotOptionsPaneLayout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addComponent(confLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(confLevelSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
              .addComponent(predIntCheck))
            .addGap(77, 77, 77))))
    );
    plotOptionsPaneLayout.setVerticalGroup(
      plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotOptionsPaneLayout.createSequentialGroup()
        .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(regLineCheck)
          .addComponent(confIntCheck))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(loessLineCheck)
          .addComponent(predIntCheck, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(plotOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(confLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(confLevelSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap())
    );

    javax.swing.GroupLayout plotPaneLayout = new javax.swing.GroupLayout(plotPane);
    plotPane.setLayout(plotPaneLayout);
    plotPaneLayout.setHorizontalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addGap(12, 12, 12)
        .addGroup(plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(topPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 708, Short.MAX_VALUE)
          .addComponent(plotOptionsPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 708, Short.MAX_VALUE))
        .addContainerGap())
    );
    plotPaneLayout.setVerticalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addComponent(topPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(plotOptionsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
    );

    java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
    setBounds((screenSize.width-800)/2, (screenSize.height-511)/2, 800, 511);
  }// </editor-fold>//GEN-END:initComponents

    private void regLineCheckActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_regLineCheckActionPerformed
      refreshConfPredInt();
    }//GEN-LAST:event_regLineCheckActionPerformed

    private void loessLineCheckActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loessLineCheckActionPerformed
      refreshConfPredInt();
    }//GEN-LAST:event_loessLineCheckActionPerformed
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox confIntCheck;
  private javax.swing.JLabel confLabel;
  private javax.swing.JSpinner confLevelSpinner;
  private javax.swing.JCheckBox loessLineCheck;
  private javax.swing.JPanel plotLabelsPane;
  private javax.swing.JPanel plotOptionsPane;
  private javax.swing.JPanel plotPane;
  private javax.swing.JTextField plotTitle;
  private javax.swing.JLabel plotTitleLabel;
  private javax.swing.JCheckBox predIntCheck;
  private javax.swing.JCheckBox regLineCheck;
  private javax.swing.JPanel topPane;
  private javax.swing.JPanel varPane;
  private javax.swing.JTextField xAxis;
  private javax.swing.JLabel xAxisLabel;
  private javax.swing.JComboBox xComboBox;
  private javax.swing.JLabel xLabel;
  private javax.swing.JTextField yAxis;
  private javax.swing.JLabel yAxisLabel;
  private javax.swing.JComboBox yComboBox;
  private javax.swing.JLabel yLabel;
  // End of variables declaration//GEN-END:variables

  @Override
  protected void submitButtonAction()
  {
    PreferencesManager prefsManager = new PreferencesManager();

    try
    {
      prefsManager.importPreferences();
    }
    catch (Exception ex)
    {
      Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
    }

    String cmd = "scatterplot2.JGR("
      + "my.data=" + this.getDatasetPane().getSelectedDataset()
      + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'")
      + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")")
      + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'")
      + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")")
      + ", x=" + "'" + GUIUtils.getSelectedItem(xComboBox) + "'"
      + ", y=" + "'" + GUIUtils.getSelectedItem(yComboBox) + "'"
      + ", main=" + "'" + plotTitle.getText() + "'"
      + ", xlab=" + "'" + xAxis.getText() + "'"
      + ", ylab=" + "'" + yAxis.getText() + "'"
      + ", add.lm=" + String.valueOf(regLineCheck.isSelected()).toUpperCase()
      + ", add.loess=" + String.valueOf(loessLineCheck.isSelected()).toUpperCase()
      + ", add.conf=" + String.valueOf(confIntCheck.isSelected()).toUpperCase()
      + ", add.pred=" + String.valueOf(predIntCheck.isSelected()).toUpperCase()
      + ", conf=" + ((Double) confLevelSpinner.getValue()).doubleValue()
      + ", " + prefsManager.getCadstatPreferences().toString()
      + ")";
    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  protected void helpButtonAction()
  {
    String cmd = "CADStat.help('scatterplot.JGR')";
    JGR.MAINRCONSOLE.execute(cmd, true);
    //JGR.MAINRCONSOLE.help("Scatterplot");
  }

  @Override
  public void windowActivated(WindowEvent e)
  {
    Object currX = xComboBox.getSelectedItem();
    Object currY = yComboBox.getSelectedItem();

    this.getDatasetPane().refreshDatasetComboBox();
    xComboBox.setSelectedItem(currX);
    yComboBox.setSelectedItem(currY);

    refreshVariableListValidity();
    refreshSubmitButtonValidity();
  }
}
